/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.net.SocketAddress;
import java.net.UnixDomainSocketAddress;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.Epoll;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.EpollDomainSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueue;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueueSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.socket.nio.NioDomainSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.unix.DomainSocketAddress;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUring;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUringDomainSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUringSocketChannel;

public interface NettyTransport {
    public static boolean isEpollAvailable() {
        return EpollNettyTransport.isEpollAvailable();
    }

    public static NettyTransport epoll() {
        return new EpollNettyTransport();
    }

    public static boolean isIoUringAvailable() {
        return IoUringNettyTransport.isIoUringAvailable();
    }

    public static NettyTransport ioUring() {
        return new IoUringNettyTransport();
    }

    public static boolean isKQueueAvailable() {
        return KQueueNettyTransport.isKQueueAvailable();
    }

    public static NettyTransport kqueue() {
        return new KQueueNettyTransport();
    }

    public static NettyTransport local() {
        return new LocalNettyTransport();
    }

    public Type type();

    public Class<? extends Channel> channelClass(String var1);

    public SocketAddress domainSocketAddress(String var1);

    public boolean fastOpenAvailable();

    public static NettyTransport nio() {
        return new NioNettyTransport();
    }

    public record EpollNettyTransport() implements NettyTransport
    {
        private static final String EPOLL_NAME = "org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.Epoll";

        static boolean isEpollAvailable() {
            try {
                Class.forName(EPOLL_NAME);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return Epoll.isAvailable();
        }

        @Override
        public Type type() {
            return Type.EPOLL;
        }

        @Override
        public Class<? extends Channel> channelClass(String scheme) {
            return "bolt+unix".equals(scheme) ? EpollDomainSocketChannel.class : EpollSocketChannel.class;
        }

        @Override
        public SocketAddress domainSocketAddress(String file) {
            return new DomainSocketAddress(file);
        }

        @Override
        public boolean fastOpenAvailable() {
            return Epoll.isTcpFastOpenClientSideAvailable();
        }
    }

    public record IoUringNettyTransport() implements NettyTransport
    {
        private static final String IO_URING_NAME = "org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUring";

        static boolean isIoUringAvailable() {
            try {
                Class.forName(IO_URING_NAME);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return IoUring.isAvailable();
        }

        @Override
        public Type type() {
            return Type.IO_URING;
        }

        @Override
        public Class<? extends Channel> channelClass(String scheme) {
            return "bolt+unix".equals(scheme) ? IoUringDomainSocketChannel.class : IoUringSocketChannel.class;
        }

        @Override
        public SocketAddress domainSocketAddress(String file) {
            return new DomainSocketAddress(file);
        }

        @Override
        public boolean fastOpenAvailable() {
            return IoUring.isTcpFastOpenClientSideAvailable();
        }
    }

    public record KQueueNettyTransport() implements NettyTransport
    {
        private static final String KQUEUE_NAME = "org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueue";

        static boolean isKQueueAvailable() {
            try {
                Class.forName(KQUEUE_NAME);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return KQueue.isAvailable();
        }

        @Override
        public Type type() {
            return Type.KQUEUE;
        }

        @Override
        public Class<? extends Channel> channelClass(String scheme) {
            return "bolt+unix".equals(scheme) ? KQueueDomainSocketChannel.class : KQueueSocketChannel.class;
        }

        @Override
        public SocketAddress domainSocketAddress(String file) {
            return new DomainSocketAddress(file);
        }

        @Override
        public boolean fastOpenAvailable() {
            return KQueue.isTcpFastOpenClientSideAvailable();
        }
    }

    public record LocalNettyTransport() implements NettyTransport
    {
        @Override
        public Type type() {
            return Type.LOCAL;
        }

        @Override
        public Class<? extends Channel> channelClass(String scheme) {
            return LocalChannel.class;
        }

        @Override
        public SocketAddress domainSocketAddress(String file) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean fastOpenAvailable() {
            return false;
        }
    }

    public record NioNettyTransport() implements NettyTransport
    {
        @Override
        public Type type() {
            return Type.NIO;
        }

        @Override
        public Class<? extends Channel> channelClass(String scheme) {
            return "bolt+unix".equals(scheme) ? NioDomainSocketChannel.class : NioSocketChannel.class;
        }

        @Override
        public SocketAddress domainSocketAddress(String file) {
            return UnixDomainSocketAddress.of(file);
        }

        @Override
        public boolean fastOpenAvailable() {
            return false;
        }
    }

    public static enum Type {
        NIO,
        EPOLL,
        IO_URING,
        KQUEUE,
        LOCAL;

    }
}

