/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseName;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.MessageWithMetadata;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.request.TransactionMetadataBuilder;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

public class RunWithMetadataMessage
extends MessageWithMetadata {
    public static final byte SIGNATURE = 16;
    private static final String NAME = "RUN";
    private final String query;
    private final Map<String, Value> parameters;

    public static RunWithMetadataMessage autoCommitTxRunMessage(String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, DatabaseName databaseName, AccessMode mode, Set<String> bookmarks, String impersonatedUser, NotificationConfig notificationConfig, boolean legacyNotifications, LoggingProvider logging, ValueFactory valueFactory) {
        Map<String, Value> metadata = TransactionMetadataBuilder.buildMetadata(txTimeout, txMetadata, databaseName, mode, bookmarks, impersonatedUser, null, notificationConfig, legacyNotifications, logging, valueFactory);
        return new RunWithMetadataMessage(query, parameters, metadata);
    }

    public static RunWithMetadataMessage unmanagedTxRunMessage(String query, Map<String, Value> parameters) {
        return new RunWithMetadataMessage(query, parameters, Collections.emptyMap());
    }

    private RunWithMetadataMessage(String query, Map<String, Value> parameters, Map<String, Value> metadata) {
        super(metadata);
        this.query = query;
        this.parameters = parameters;
    }

    public String query() {
        return this.query;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public byte signature() {
        return 16;
    }

    @Override
    public String name() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunWithMetadataMessage that = (RunWithMetadataMessage)o;
        return Objects.equals(this.query, that.query) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.metadata(), that.metadata());
    }

    public int hashCode() {
        return Objects.hash(this.query, this.parameters, this.metadata());
    }

    public String toString() {
        return "RUN \"" + this.query + "\" " + String.valueOf(this.parameters) + " " + String.valueOf(this.metadata());
    }
}

