/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.net.URI;
import java.net.http.HttpClient;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.AuthInfo;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnection;
import org.neo4j.jdbc.internal.shaded.bolt.BoltConnectionState;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.BoltServerAddress;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltConnectionReadTimeoutException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltFailureException;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltServiceUnavailableException;
import org.neo4j.jdbc.internal.shaded.bolt.message.BeginMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.CommitMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.DiscardMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.LogoffMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.LogonMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.Message;
import org.neo4j.jdbc.internal.shaded.bolt.message.PullMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.ResetMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.RollbackMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.RunMessage;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ImmutableObservation;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ObservationProvider;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.AuthInfoImpl;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.BeginMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.CommitMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.DiscardMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.DriverValueProvider;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.FutureUtil;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.HttpContext;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.LogoffMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.LogonMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.MessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.PullMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.Query;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.ResetMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.RollbackMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.RunMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.TransactionInfo;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSON;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JacksonJrExtension;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.api.ExtensionContext;

public final class QueryApiBoltConnection
implements BoltConnection {
    private static final CompletionStage<Void> MESSAGE_HANDLING_WITH_IGNORING_STAGE = CompletableFuture.failedStage(new IllegalStateException("ignore messages"));
    private static final CompletionStage<Void> MESSAGE_HANDLING_ABORTING_STAGE = CompletableFuture.failedStage(new MessageHandlingAbortingException());
    private final JSON json;
    private final LoggingProvider logging;
    private final System.Logger log;
    private final ValueFactory valueFactory;
    private final HttpClient httpClient;
    private final URI baseUri;
    private final String userAgent;
    private final String serverAgent;
    private final BoltProtocolVersion boltProtocolVersion;
    private final Clock clock;
    private final ObservationProvider observationProvider;
    private final List<Message> messages = new ArrayList<Message>();
    private final Map<Long, Query> qidToQuery = new HashMap<Long, Query>();
    private TransactionInfo transactionInfo;
    private CompletionStage<Void> execTail = CompletableFuture.completedFuture(null);
    private BoltConnectionState state = BoltConnectionState.OPEN;
    private String authHeader;
    private CompletableFuture<AuthInfo> authInfoFuture;
    private Duration readTimeout;

    public QueryApiBoltConnection(final ValueFactory valueFactory, HttpClient httpClient, URI baseUri, AuthToken authToken, String userAgent, String serverAgent, BoltProtocolVersion boltProtocolVersion, Clock clock, LoggingProvider logging, ObservationProvider observationProvider) {
        this.logging = logging;
        this.log = logging.getLog(this.getClass());
        this.valueFactory = Objects.requireNonNull(valueFactory);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.baseUri = Objects.requireNonNull(baseUri);
        this.userAgent = userAgent;
        this.serverAgent = Objects.requireNonNull(serverAgent);
        this.json = JSON.builder().register(new JacksonJrExtension(){

            @Override
            protected void register(ExtensionContext ctxt) {
                ctxt.appendProvider(new DriverValueProvider(valueFactory));
            }
        }).build();
        this.boltProtocolVersion = Objects.requireNonNull(boltProtocolVersion);
        this.clock = Objects.requireNonNull(clock);
        this.observationProvider = Objects.requireNonNull(observationProvider);
        this.updateAuthHeader(authToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> writeAndFlush(ResponseHandler handler, List<Message> messages, ImmutableObservation parentObservation) {
        try {
            QueryApiBoltConnection queryApiBoltConnection = this;
            synchronized (queryApiBoltConnection) {
                this.assertValidStateForWrite();
                ArrayList<Message> messagesToWrite = new ArrayList<Message>(this.messages);
                this.messages.clear();
                messagesToWrite.addAll(messages);
                List<MessageHandler<?>> messageHandlers = this.initMessageHandlers(handler, messagesToWrite);
                CompletionStage<Void> messageHandling = this.setupMessageHandling(handler, messageHandlers, this.execTail, parentObservation);
                this.execTail = this.execTail.thenCompose(ignored -> messageHandling);
            }
            return CompletableFuture.completedStage(null);
        }
        catch (Throwable t) {
            return CompletableFuture.failedStage(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<Void> write(List<Message> messages) {
        try {
            QueryApiBoltConnection queryApiBoltConnection = this;
            synchronized (queryApiBoltConnection) {
                this.assertValidStateForWrite();
                this.messages.addAll(messages);
            }
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable throwable) {
            return CompletableFuture.failedStage(throwable);
        }
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        return CompletableFuture.completedStage(null);
    }

    @Override
    public CompletionStage<Void> close() {
        return CompletableFuture.completedStage(null);
    }

    @Override
    public synchronized CompletionStage<Void> setReadTimeout(Duration duration) {
        if (duration != null && (duration.isNegative() || Duration.ZERO.equals(duration))) {
            return CompletableFuture.failedStage(new IllegalArgumentException("Invalid duration: " + String.valueOf(duration)));
        }
        this.readTimeout = duration;
        return CompletableFuture.completedStage(null);
    }

    @Override
    public synchronized BoltConnectionState state() {
        return this.state;
    }

    @Override
    public synchronized CompletionStage<AuthInfo> authInfo() {
        return this.authInfoFuture;
    }

    @Override
    public String serverAgent() {
        return this.serverAgent;
    }

    @Override
    public BoltServerAddress serverAddress() {
        return new BoltServerAddress(this.baseUri.getHost(), this.getPort());
    }

    @Override
    public BoltProtocolVersion protocolVersion() {
        return this.boltProtocolVersion;
    }

    @Override
    public boolean telemetrySupported() {
        return false;
    }

    @Override
    public boolean serverSideRoutingEnabled() {
        return true;
    }

    @Override
    public Optional<Duration> defaultReadTimeout() {
        return Optional.empty();
    }

    synchronized void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    synchronized TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    synchronized void addQuery(long id, Query query) {
        this.qidToQuery.put(id, query);
    }

    synchronized Query findById(long id) {
        return this.qidToQuery.get(id);
    }

    private synchronized void deleteById(long id) {
        this.qidToQuery.remove(id);
    }

    private synchronized List<MessageHandler<?>> initMessageHandlers(ResponseHandler handler, List<Message> messages) {
        ArrayList messageHandlers = new ArrayList(messages.size());
        for (int i = 0; i < messages.size(); ++i) {
            HttpContext httpContext;
            Message message = messages.get(i);
            if (message instanceof BeginMessage) {
                BeginMessage beginMessage = (BeginMessage)message;
                httpContext = new HttpContext(this.httpClient, this.baseUri, this.json, this.userAgent);
                messageHandlers.add(new BeginMessageHandler(handler, httpContext, this::authHeader, beginMessage, this.readTimeout, this.valueFactory, this.logging, this.observationProvider));
                continue;
            }
            if (message instanceof RunMessage) {
                RunMessage runMessage = (RunMessage)message;
                httpContext = new HttpContext(this.httpClient, this.baseUri, this.json, this.userAgent);
                messageHandlers.add(new RunMessageHandler(handler, httpContext, this::authHeader, runMessage, this::getTransactionInfo, this.readTimeout, this.valueFactory, this.logging, this.observationProvider));
                continue;
            }
            if (message instanceof PullMessage) {
                PullMessage pullMessage = (PullMessage)message;
                if (pullMessage.qid() != -1L && !this.qidToQuery.containsKey(pullMessage.qid())) {
                    throw new BoltClientException("Pull query does not contain query id: " + pullMessage.qid());
                }
                messageHandlers.add(new PullMessageHandler(handler, pullMessage, this::findById, this::deleteById, this.logging));
                continue;
            }
            if (message instanceof DiscardMessage) {
                DiscardMessage discardMessage = (DiscardMessage)message;
                if (discardMessage.qid() != -1L && !this.qidToQuery.containsKey(discardMessage.qid())) {
                    throw new BoltClientException("Discard query does not contain query id: " + discardMessage.qid());
                }
                messageHandlers.add(new DiscardMessageHandler(handler, discardMessage, this::findById, this::deleteById, this.logging));
                continue;
            }
            if (message instanceof CommitMessage) {
                httpContext = new HttpContext(this.httpClient, this.baseUri, this.json, this.userAgent);
                messageHandlers.add(new CommitMessageHandler(handler, httpContext, this::authHeader, this::getTransactionInfo, this.readTimeout, this.valueFactory, this.logging, this.observationProvider));
                continue;
            }
            if (message instanceof RollbackMessage) {
                httpContext = new HttpContext(this.httpClient, this.baseUri, this.json, this.userAgent);
                messageHandlers.add(new RollbackMessageHandler(handler, httpContext, this::authHeader, this::getTransactionInfo, this.readTimeout, this.valueFactory, this.logging, this.observationProvider));
                continue;
            }
            if (message instanceof ResetMessage) {
                if (i > 0) {
                    throw new BoltClientException("Reset message is only supported at the beginning of message pipeline");
                }
                messageHandlers.add(new ResetMessageHandler(this::state, this::updateState, handler));
                continue;
            }
            if (message instanceof LogoffMessage) {
                Message nextMessage = messages.get(i + 1);
                if (nextMessage instanceof LogonMessage) {
                    LogonMessage logonMessage = (LogonMessage)nextMessage;
                    messageHandlers.add(new LogoffMessageHandler(handler));
                    messageHandlers.add(new LogonMessageHandler(handler, logonMessage, this::updateAuthHeader));
                    ++i;
                    continue;
                }
                throw new BoltClientException("Logoff message is only supported when Logon message is sent immediately after it");
            }
            if (message instanceof LogonMessage) {
                LogonMessage logonMessage = (LogonMessage)message;
                throw new BoltClientException("Logon message is only supported immediately after Logoff message");
            }
            throw new BoltClientException(String.format("%s not supported", message.getClass().getCanonicalName()));
        }
        return messageHandlers;
    }

    private synchronized CompletionStage<Void> setupMessageHandling(ResponseHandler handler, List<MessageHandler<?>> messageHandlers, CompletionStage<Void> previousExecution, ImmutableObservation parentObservation) {
        CompletableFuture<Void> messageHandlingFuture = new CompletableFuture<Void>();
        CompletionStage<Void> exchange = previousExecution.whenComplete((result, throwable) -> {});
        for (int i = 0; i < messageHandlers.size(); ++i) {
            MessageHandler<?> messageHandler = messageHandlers.get(i);
            if (i == 0) {
                exchange = QueryApiBoltConnection.appendMessageHandler(handler, exchange, () -> {
                    CompletionStage<Void> result;
                    QueryApiBoltConnection queryApiBoltConnection = this;
                    synchronized (queryApiBoltConnection) {
                        result = switch (this.state()) {
                            default -> throw new IncompatibleClassChangeError();
                            case BoltConnectionState.OPEN -> CompletableFuture.completedStage(null);
                            case BoltConnectionState.ERROR, BoltConnectionState.CLOSED -> MESSAGE_HANDLING_ABORTING_STAGE;
                            case BoltConnectionState.FAILURE -> messageHandler instanceof ResetMessageHandler ? CompletableFuture.completedStage(null) : MESSAGE_HANDLING_WITH_IGNORING_STAGE;
                        };
                    }
                    return result;
                });
            }
            if (messageHandler instanceof BeginMessageHandler) {
                BeginMessageHandler beginMessageHandler = (BeginMessageHandler)messageHandler;
                exchange = QueryApiBoltConnection.appendMessageHandler(handler, exchange, () -> beginMessageHandler.exchange(parentObservation).thenApply(transactionInfo -> {
                    this.setTransactionInfo((TransactionInfo)transactionInfo);
                    return null;
                }));
                continue;
            }
            if (messageHandler instanceof RunMessageHandler) {
                RunMessageHandler runMessageHandler = (RunMessageHandler)messageHandler;
                exchange = QueryApiBoltConnection.appendMessageHandler(handler, exchange, () -> runMessageHandler.exchange(parentObservation).thenApply(query -> {
                    QueryApiBoltConnection queryApiBoltConnection = this;
                    synchronized (queryApiBoltConnection) {
                        this.addQuery(query.id(), (Query)query);
                        this.addQuery(-1L, (Query)query);
                    }
                    return null;
                }));
                continue;
            }
            if (messageHandler instanceof CommitMessageHandler) {
                CommitMessageHandler commitMessageHandler = (CommitMessageHandler)messageHandler;
                exchange = QueryApiBoltConnection.appendMessageHandler(handler, exchange, () -> commitMessageHandler.exchange(parentObservation).thenApply(ignored0 -> {
                    QueryApiBoltConnection queryApiBoltConnection = this;
                    synchronized (queryApiBoltConnection) {
                        this.setTransactionInfo(null);
                        this.qidToQuery.clear();
                    }
                    return null;
                }));
                continue;
            }
            if (messageHandler instanceof RollbackMessageHandler) {
                RollbackMessageHandler rollbackMessageHandler = (RollbackMessageHandler)messageHandler;
                exchange = QueryApiBoltConnection.appendMessageHandler(handler, exchange, () -> rollbackMessageHandler.exchange(parentObservation).thenApply(transactionInfo -> {
                    QueryApiBoltConnection queryApiBoltConnection = this;
                    synchronized (queryApiBoltConnection) {
                        this.setTransactionInfo(null);
                        this.qidToQuery.clear();
                    }
                    return null;
                }));
                continue;
            }
            exchange = QueryApiBoltConnection.appendMessageHandler(handler, exchange, () -> messageHandler.exchange(parentObservation).thenApply(ignored0 -> null));
        }
        exchange.whenComplete((ignored, throwable) -> {
            if (throwable != null) {
                throwable = FutureUtil.completionExceptionCause(throwable);
                QueryApiBoltConnection queryApiBoltConnection = this;
                synchronized (queryApiBoltConnection) {
                    BoltConnectionState newState;
                    if (throwable instanceof BoltServiceUnavailableException) {
                        newState = throwable instanceof BoltConnectionReadTimeoutException ? BoltConnectionState.ERROR : BoltConnectionState.CLOSED;
                    } else if (throwable instanceof BoltFailureException) {
                        BoltFailureException boltFailureException = (BoltFailureException)throwable;
                        newState = "Neo.ClientError.Security.AuthorizationExpired".equals(boltFailureException.code()) ? BoltConnectionState.ERROR : BoltConnectionState.FAILURE;
                    } else {
                        newState = switch (this.state) {
                            default -> throw new IncompatibleClassChangeError();
                            case BoltConnectionState.OPEN, BoltConnectionState.FAILURE, BoltConnectionState.ERROR -> BoltConnectionState.ERROR;
                            case BoltConnectionState.CLOSED -> BoltConnectionState.CLOSED;
                        };
                    }
                    this.updateState(newState);
                }
                if (throwable instanceof MessageHandlingAbortingException) {
                    handler.onError(new BoltServiceUnavailableException("Failed to handle messages, the connection is no longer in a valid state"));
                }
            }
            handler.onComplete();
            messageHandlingFuture.complete(null);
        });
        return messageHandlingFuture;
    }

    private int getPort() {
        if (this.baseUri.getPort() == -1) {
            if (this.baseUri.getScheme().equals("https")) {
                return 443;
            }
            return 80;
        }
        return this.baseUri.getPort();
    }

    private synchronized void assertValidStateForWrite() {
        switch (this.state) {
            case OPEN: 
            case FAILURE: {
                break;
            }
            case ERROR: 
            case CLOSED: {
                throw new BoltClientException("Failed to write to connection in %s state".formatted(new Object[]{this.state}));
            }
        }
    }

    synchronized void updateState(BoltConnectionState state) {
        this.state = state;
        this.transactionInfo = null;
        this.qidToQuery.clear();
    }

    private static CompletionStage<Void> appendMessageHandler(ResponseHandler handler, CompletionStage<Void> previous, Supplier<CompletionStage<Void>> messageSupplier) {
        return previous.handle((ignored, throwable) -> {
            if (throwable != null) {
                if (!((throwable = FutureUtil.completionExceptionCause(throwable)) instanceof MessageHandlingAbortingException)) {
                    handler.onIgnored();
                }
                return CompletableFuture.failedStage(throwable);
            }
            return ((CompletionStage)messageSupplier.get()).whenComplete((handlerResult, handlerError) -> {
                if (handlerError != null) {
                    handlerError = FutureUtil.completionExceptionCause(handlerError);
                    handler.onError((Throwable)handlerError);
                }
            });
        }).thenCompose(Function.identity());
    }

    private synchronized String authHeader() {
        return this.authHeader;
    }

    private synchronized void updateAuthHeader(AuthToken authToken) {
        String scheme;
        Map<String, Value> authMap = authToken.asMap();
        this.authHeader = switch (scheme = authMap.get("scheme").asString()) {
            case "basic" -> {
                String username = authMap.get("principal").asString();
                String password = authMap.get("credentials").asString();
                yield "Basic " + Base64.getEncoder().encodeToString("%s:%s".formatted(username, password).getBytes());
            }
            case "bearer" -> {
                String token = authMap.get("credentials").asString();
                yield "Bearer " + token;
            }
            case "none" -> null;
            default -> throw new BoltClientException("Unsupported auth token: { scheme='" + scheme + "' }");
        };
        this.authInfoFuture = CompletableFuture.completedFuture(new AuthInfoImpl(authToken, this.clock.millis()));
    }

    private static class MessageHandlingAbortingException
    extends RuntimeException {
        private static final long serialVersionUID = 2360301147486954597L;

        private MessageHandlingAbortingException() {
        }
    }
}

