/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.neo4j.jdbc.internal.shaded.cypherdsl.BooleanFunctionCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.BuiltInFunctions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExistentialSubquery;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ListPredicate;
import org.neo4j.jdbc.internal.shaded.cypherdsl.OngoingListBasedPredicateFunction;
import org.neo4j.jdbc.internal.shaded.cypherdsl.OngoingListBasedPredicateFunctionWithList;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RelationshipPattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

final class Predicates {
    private Predicates() {
    }

    static Condition exists(Property property) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, property));
    }

    static Condition exists(RelationshipPattern pattern) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.EXISTS, pattern));
    }

    static Condition exists(Statement statement, IdentifiableElement ... imports) {
        return ExistentialSubquery.exists(statement, imports);
    }

    static Condition exists(PatternElement pattern) {
        return ExistentialSubquery.exists(List.of(pattern), null);
    }

    static Condition exists(List<PatternElement> pattern) {
        return ExistentialSubquery.exists(pattern, null);
    }

    static Condition exists(List<PatternElement> pattern, Where where) {
        return ExistentialSubquery.exists(pattern, where);
    }

    static OngoingListBasedPredicateFunction all(String variable) {
        return Predicates.all(SymbolicName.of(variable));
    }

    static OngoingListBasedPredicateFunction all(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.ALL, variable);
    }

    static OngoingListBasedPredicateFunction any(String variable) {
        return Predicates.any(SymbolicName.of(variable));
    }

    static OngoingListBasedPredicateFunction any(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.ANY, variable);
    }

    static OngoingListBasedPredicateFunction none(String variable) {
        return Predicates.none(SymbolicName.of(variable));
    }

    static OngoingListBasedPredicateFunction none(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.NONE, variable);
    }

    static OngoingListBasedPredicateFunction single(String variable) {
        return Predicates.single(SymbolicName.of(variable));
    }

    static OngoingListBasedPredicateFunction single(SymbolicName variable) {
        return new Builder(BuiltInFunctions.Predicates.SINGLE, variable);
    }

    static Condition isEmpty(Expression e) {
        return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)BuiltInFunctions.Predicates.IS_EMPTY, e));
    }

    private static class Builder
    implements OngoingListBasedPredicateFunction,
    OngoingListBasedPredicateFunctionWithList {
        private final BuiltInFunctions.Predicates predicate;
        private final SymbolicName name;
        private Expression listExpression;

        Builder(BuiltInFunctions.Predicates predicate, SymbolicName name) {
            Assertions.notNull(predicate, "The predicate is required");
            Assertions.notNull(name, "The name is required");
            this.predicate = predicate;
            this.name = name;
        }

        @Override
        public OngoingListBasedPredicateFunctionWithList in(Expression list) {
            Assertions.notNull(list, "The list expression is required");
            this.listExpression = list;
            return this;
        }

        @Override
        public Condition where(Condition condition) {
            Assertions.notNull(condition, "The condition is required");
            return new BooleanFunctionCondition(FunctionInvocation.create((FunctionInvocation.FunctionDefinition)this.predicate, new ListPredicate(this.name, this.listExpression, new Where(condition))));
        }
    }
}

