/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.SQLException;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPartInternal;
import org.neo4j.jdbc.internal.shaded.jooq.exception.DataAccessException;
import org.neo4j.jdbc.internal.shaded.jooq.exception.SQLDialectNotSupportedException;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.InternalConfiguration;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

abstract class AbstractQueryPart
implements QueryPartInternal {
    AbstractQueryPart() {
    }

    Configuration configuration() {
        return Tools.CONFIG.get();
    }

    @Override
    @Deprecated
    public Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public boolean rendersContent(Context<?> ctx) {
        return true;
    }

    @Override
    public boolean declaresFields() {
        return false;
    }

    @Override
    public boolean declaresTables() {
        return false;
    }

    @Override
    public boolean declaresWindows() {
        return false;
    }

    @Override
    public boolean declaresCTE() {
        return false;
    }

    @Override
    public boolean generatesCast() {
        return false;
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof QueryPart) {
            Configuration configuration;
            QueryPart q = (QueryPart)that;
            Configuration c1 = Tools.configuration(this.configuration());
            if (that instanceof AbstractQueryPart) {
                AbstractQueryPart a = (AbstractQueryPart)that;
                configuration = Tools.configuration(a.configuration());
            } else {
                configuration = c1;
            }
            Configuration c2 = configuration;
            DSLContext dsl1 = c1.dsl();
            DSLContext dsl2 = c2 == c1 ? dsl1 : c2.dsl();
            String sql1 = dsl1.renderInlined(this);
            String sql2 = dsl2.renderInlined(q);
            return sql1.equals(sql2);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.create().renderInlined(this).hashCode();
    }

    @Override
    public String toString() {
        try {
            Configuration configuration = Tools.configuration(this.configuration());
            if (configuration instanceof InternalConfiguration) {
                return this.create(Tools.CONFIG_FORMATTED.get()).renderInlined(this);
            }
            return this.create(configuration.deriveSettings(s -> s.withRenderFormatted(true))).renderInlined(this);
        }
        catch (SQLDialectNotSupportedException e) {
            return "[ ... " + e.getMessage() + " ... ]";
        }
    }

    @Deprecated
    protected final DSLContext create() {
        return this.create(this.configuration());
    }

    @Deprecated
    protected final DSLContext create(Configuration configuration) {
        return DSL.using(configuration);
    }

    @Deprecated
    protected final DSLContext create(Context<?> ctx) {
        return DSL.using(ctx.configuration());
    }

    protected final DataAccessException translate(String sql, SQLException e) {
        return Tools.translate(sql, e);
    }
}

