/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Record1;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.TableLike;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class ArrayQuery<T>
extends AbstractField<T[]>
implements QOM.ArrayQuery<T> {
    private final Select<? extends Record1<T>> query;

    ArrayQuery(Select<? extends Record1<T>> query) {
        super(Names.N_ARRAY, query.getSelect().get(0).getDataType().getArrayDataType());
        this.query = query;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                Table t = this.query.asTable("t", "c");
                Field<?> c = t.field("c");
                Tools.visitSubquery(ctx, DSL.select(DSL.arrayAgg(c)).from((TableLike<?>)t));
                break;
            }
            default: {
                ctx.visit(Keywords.K_ARRAY).visitSubquery(this.query);
            }
        }
    }

    @Override
    public final Select<? extends Record1<T>> $query() {
        return this.query;
    }
}

