/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

final class ConcurrentReadWriteMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final Map<K, V> map;
    private final ReadWriteLock rw;
    private final Lock read;
    private final Lock write;

    ConcurrentReadWriteMap(Map<K, V> map) {
        this.map = map;
        this.rw = new ReentrantReadWriteLock();
        this.read = this.rw.readLock();
        this.write = this.rw.writeLock();
    }

    @Override
    public int size() {
        this.read.lock();
        try {
            int n = this.map.size();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.read.lock();
        try {
            boolean bl = this.map.isEmpty();
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.read.lock();
        try {
            boolean bl = this.map.containsKey(key);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.read.lock();
        try {
            boolean bl = this.map.containsValue(value);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public V get(Object key) {
        this.read.lock();
        try {
            V v = this.map.get(key);
            return v;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getOrDefault(Object key, V defaultValue) {
        this.read.lock();
        try {
            V v = this.map.getOrDefault(key, defaultValue);
            return v;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.read.lock();
        try {
            this.map.forEach(action);
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public boolean equals(Object o) {
        this.read.lock();
        try {
            boolean bl = this.map.equals(o);
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public int hashCode() {
        this.read.lock();
        try {
            int n = this.map.hashCode();
            return n;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public String toString() {
        this.read.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.write.lock();
        try {
            V v = this.map.put(key, value);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        this.write.lock();
        try {
            V v = this.map.remove(key);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.write.lock();
        try {
            this.map.putAll(m);
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void clear() {
        this.write.lock();
        try {
            this.map.clear();
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        this.write.lock();
        try {
            boolean bl = this.map.remove(key, value);
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.write.lock();
        try {
            boolean bl = this.map.replace(key, oldValue, newValue);
            return bl;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.write.lock();
        try {
            this.map.replaceAll(function);
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.write.lock();
        try {
            V v = this.map.putIfAbsent(key, value);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.write.lock();
        try {
            V v = this.map.replace(key, value);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        this.write.lock();
        try {
            V v = this.map.computeIfAbsent((K)key, mappingFunction);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.write.lock();
        try {
            V v = this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        this.write.lock();
        try {
            V v = this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        this.write.lock();
        try {
            V v = this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
            return v;
        }
        finally {
            this.write.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<K, V>> s = this.map.entrySet();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return ConcurrentReadWriteMap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator it = s.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        ConcurrentReadWriteMap.this.read.lock();
                        try {
                            boolean bl = it.hasNext();
                            return bl;
                        }
                        finally {
                            ConcurrentReadWriteMap.this.read.unlock();
                        }
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        ConcurrentReadWriteMap.this.read.lock();
                        try {
                            Map.Entry entry = (Map.Entry)it.next();
                            return entry;
                        }
                        finally {
                            ConcurrentReadWriteMap.this.read.unlock();
                        }
                    }
                };
            }
        };
    }
}

