/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Comment;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Alias;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SimpleCheckQueryPart;

final class FieldAlias<T>
extends AbstractField<T>
implements QOM.FieldAlias<T>,
SimpleCheckQueryPart {
    private final Alias<Field<T>> alias;

    FieldAlias(Field<T> field, Name alias) {
        this(field, alias, null);
    }

    FieldAlias(Field<T> field, Name alias, Comment comment) {
        super(alias, field.getDataType(), comment);
        this.alias = new Alias<FieldAlias>((FieldAlias)field, this, alias);
    }

    @Override
    public final boolean isSimple(Context<?> ctx) {
        return !ctx.declareFields();
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.alias);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final Field<T> as(Name as) {
        return new FieldAlias<T>(this.alias.wrapped(), as, this.getCommentPart());
    }

    @Override
    public final Field<T> comment(Comment comment) {
        return new FieldAlias<T>(this.alias.wrapped(), this.alias.alias, comment);
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public Name getQualifiedName() {
        return this.getUnqualifiedName();
    }

    Field<T> getAliasedField() {
        if (this.alias != null) {
            return this.alias.wrapped();
        }
        return null;
    }

    @Override
    public final Field<T> $field() {
        return this.alias.wrapped();
    }

    @Override
    public final Field<?> $aliased() {
        return this.alias.wrapped();
    }

    @Override
    @NotNull
    public final Name $alias() {
        return this.getQualifiedName();
    }

    @Override
    public int hashCode() {
        return this.alias.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof FieldAlias) {
            FieldAlias o = (FieldAlias)that;
            return Objects.equals(this.alias, o.alias);
        }
        return super.equals(that);
    }
}

