/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.IsDistinctFrom;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class IsNotDistinctFrom<T>
extends AbstractCondition
implements QOM.IsNotDistinctFrom<T> {
    final Field<T> arg1;
    final Field<T> arg2;

    IsNotDistinctFrom(Field<T> arg1, Field<T> arg2) {
        this.arg1 = Tools.nullableIf(true, Tools.nullSafe(arg1, arg2.getDataType()));
        this.arg2 = Tools.nullableIf(true, Tools.nullSafe(arg2, arg1.getDataType()));
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.arg1.getDataType().isEmbeddable() && this.arg2.getDataType().isEmbeddable()) {
            ctx.visit(DSL.row(Tools.embeddedFields(this.arg1)).isNotDistinctFrom(DSL.row(Tools.embeddedFields(this.arg2))));
        } else if (IsDistinctFrom.EMULATE_DISTINCT_PREDICATE.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.exists(DSL.select(this.arg1.as("x")).intersect((Select)DSL.select(this.arg2.as("x")))));
        } else if (IsDistinctFrom.SUPPORT_DISTINCT_WITH_ARROW.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.condition("{0} <=> {1}", this.arg1, this.arg2));
        } else if (SQLDialect.SQLITE == ctx.family()) {
            ctx.visit(DSL.condition("{0} {is} {1}", this.arg1, this.arg2));
        } else {
            ctx.visit(this.arg1).sql(' ').visit(Keywords.K_IS).sql(' ').visit(Keywords.K_NOT).sql(' ').visit(Keywords.K_DISTINCT).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.arg2);
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.arg1;
    }

    @Override
    public final Field<T> $arg2() {
        return this.arg2;
    }

    @Override
    public final QOM.IsNotDistinctFrom<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.IsNotDistinctFrom<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.IsNotDistinctFrom<T>> $constructor() {
        return (a1, a2) -> new IsNotDistinctFrom(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.IsNotDistinctFrom) {
            QOM.IsNotDistinctFrom o = (QOM.IsNotDistinctFrom)that;
            return Objects.equals(this.$arg1(), o.$arg1()) && Objects.equals(this.$arg2(), o.$arg2());
        }
        return super.equals(that);
    }
}

