/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.JSONB;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class JSONBGetElementAsText
extends AbstractField<String>
implements QOM.JSONBGetElementAsText {
    final Field<JSONB> field;
    final Field<Integer> index;

    JSONBGetElementAsText(Field<JSONB> field, Field<Integer> index) {
        super(Names.N_JSONB_GET_ELEMENT_AS_TEXT, Tools.allNotNull(SQLDataType.VARCHAR, field, index));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.JSONB);
        this.index = Tools.nullSafeNotNull(index, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(DSL.function(Names.N_JSON_UNQUOTE, SQLDataType.JSONB, DSL.nullif(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSONB, this.field, DSL.inline("$[").concat(this.index).concat(DSL.inline("]"))), DSL.inline("null").cast(SQLDataType.JSONB))));
                break;
            }
            case MARIADB: {
                ctx.visit(DSL.function(Names.N_JSON_UNQUOTE, SQLDataType.JSONB, DSL.nullif(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSONB, this.field, DSL.inline("$[").concat(this.index).concat(DSL.inline("]"))).cast(SQLDataType.VARCHAR), DSL.inline("null"))));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_JSON_EXTRACT, SQLDataType.JSONB, this.field, DSL.inline("$[").concat(this.index).concat(DSL.inline("]"))));
                break;
            }
            default: {
                ctx.sql('(').visit(this.field).sql("->>").visit(this.index).sql(')');
            }
        }
    }

    @Override
    public final Field<JSONB> $arg1() {
        return this.field;
    }

    @Override
    public final Field<Integer> $arg2() {
        return this.index;
    }

    @Override
    public final QOM.JSONBGetElementAsText $arg1(Field<JSONB> newValue) {
        return this.$constructor().apply((Field<JSONB>)newValue, (Field<Integer>)this.$arg2());
    }

    @Override
    public final QOM.JSONBGetElementAsText $arg2(Field<Integer> newValue) {
        return this.$constructor().apply((Field<JSONB>)this.$arg1(), (Field<Integer>)newValue);
    }

    @Override
    public final Function2<? super Field<JSONB>, ? super Field<Integer>, ? extends QOM.JSONBGetElementAsText> $constructor() {
        return (a1, a2) -> new JSONBGetElementAsText((Field<JSONB>)a1, (Field<Integer>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONBGetElementAsText) {
            QOM.JSONBGetElementAsText o = (QOM.JSONBGetElementAsText)that;
            return Objects.equals(this.$field(), o.$field()) && Objects.equals(this.$index(), o.$index());
        }
        return super.equals(that);
    }
}

