/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.List;
import java.util.stream.Stream;
import org.neo4j.jdbc.internal.shaded.jooq.Catalog;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.Schema;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractNamed;
import org.neo4j.jdbc.internal.shaded.jooq.impl.CommentImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.LazySupplier;

@Internal
public final class LazyCatalog
extends AbstractNamed
implements Catalog {
    final LazySupplier<Catalog> supplier;
    transient Catalog catalog;

    public LazyCatalog(Name name, LazySupplier<Catalog> supplier) {
        super(name, CommentImpl.NO_COMMENT);
        this.supplier = supplier;
    }

    private final Catalog catalog() {
        if (this.catalog == null) {
            try {
                this.catalog = (Catalog)this.supplier.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.catalog;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.catalog());
    }

    @Override
    public final List<Schema> getSchemas() {
        return this.catalog().getSchemas();
    }

    @Override
    public final Schema getSchema(String name) {
        return this.catalog().getSchema(name);
    }

    @Override
    public final Schema getSchema(Name name) {
        return this.catalog().getSchema(name);
    }

    @Override
    public final Stream<Schema> schemaStream() {
        return this.catalog().schemaStream();
    }
}

