/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.math.BigDecimal;
import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Internal;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class Radians
extends AbstractField<BigDecimal>
implements QOM.Radians {
    final Field<? extends Number> degrees;

    Radians(Field<? extends Number> degrees) {
        super(Names.N_RADIANS, Tools.allNotNull(SQLDataType.NUMERIC, degrees));
        this.degrees = Tools.nullSafeNotNull(degrees, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                return false;
            }
            case SQLITE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: {
                ctx.visit(Internal.idiv(Internal.imul(Tools.castIfNeeded(this.degrees, BigDecimal.class), DSL.pi()), DSL.inline(180)));
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_RADIANS, this.getDataType(), this.degrees));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_RADIANS, this.getDataType(), this.degrees));
            }
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.degrees;
    }

    @Override
    public final QOM.Radians $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue);
    }

    @Override
    public final Function1<? super Field<? extends Number>, ? extends QOM.Radians> $constructor() {
        return a1 -> new Radians((Field<? extends Number>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Radians) {
            QOM.Radians o = (QOM.Radians)that;
            return Objects.equals(this.$degrees(), o.$degrees());
        }
        return super.equals(that);
    }
}

