/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;

final class RegexpReplace
extends AbstractField<String>
implements QOM.UNotYetImplemented {
    private final Field<String> field;
    private final Field<String> pattern;
    private final Field<String> replacement;
    private final boolean all;

    RegexpReplace(Field<String> field, Field<String> pattern, Field<String> replacement, boolean all) {
        super(Names.N_REGEXP_REPLACE, field.getDataType());
        this.field = field;
        this.pattern = pattern;
        this.replacement = replacement;
        this.all = all;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Names.N_REGEXP_REPLACE).sql('(').visit(this.field).sql(", ").visit(this.pattern).sql(", ").visit(this.replacement);
                if (this.all) {
                    ctx.sql(", 'g')");
                    break;
                }
                ctx.sql(')');
                break;
            }
            default: {
                ctx.visit(Names.N_REGEXP_REPLACE).sql('(').visit(this.field).sql(", ").visit(this.pattern).sql(", ").visit(this.replacement);
                if (this.all) {
                    ctx.sql(')');
                    break;
                }
                ctx.sql(", 1, 1)");
            }
        }
    }

    static String replacement(Context<?> ctx, int group) {
        switch (ctx.family()) {
            case MYSQL: {
                return "$" + group;
            }
        }
        return "\\" + group;
    }
}

