/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.Row;
import org.neo4j.jdbc.internal.shaded.jooq.Row2;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractRow;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class RowOverlaps<T1, T2>
extends AbstractCondition
implements QOM.RowOverlaps {
    private static final Set<SQLDialect> EMULATE_NON_STANDARD_OVERLAPS = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE, SQLDialect.TRINO);
    private static final Set<SQLDialect> EMULATE_INTERVAL_OVERLAPS = SQLDialect.supportedBy(SQLDialect.DUCKDB, SQLDialect.HSQLDB, SQLDialect.TRINO);
    private final Row2<T1, T2> left;
    private final Row2<T1, T2> right;

    RowOverlaps(Row2<T1, T2> left, Row2<T1, T2> right) {
        this.left = (Row2)((Object)((AbstractRow)((Object)left)).convertTo(right));
        this.right = (Row2)((Object)((AbstractRow)((Object)right)).convertTo(left));
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean intervalOverlaps;
        Field<T1> left1 = this.left.field1();
        Field<T2> left2 = this.left.field2();
        Field<T1> right1 = this.right.field1();
        Field<T2> right2 = this.right.field2();
        DataType type0 = left1.getDataType();
        DataType type1 = left2.getDataType();
        boolean standardOverlaps = type0.isDateTime() && type1.isTemporal();
        boolean bl = intervalOverlaps = type0.isDateTime() && (type1.isInterval() || type1.isNumeric());
        if (!standardOverlaps || EMULATE_NON_STANDARD_OVERLAPS.contains((Object)ctx.dialect())) {
            if (intervalOverlaps) {
                ctx.visit(right1.le(left1.plus(left2)).and(left1.le(right1.plus(right2))));
            } else {
                ctx.visit(right1.le(Tools.castIfNeeded(left2, right1)).and(left1.le(Tools.castIfNeeded(right2, left1))));
            }
        } else if (intervalOverlaps && EMULATE_INTERVAL_OVERLAPS.contains((Object)ctx.dialect())) {
            ctx.visit(right1.le(left1.plus(left2)).and(left1.le(right1.plus(right2))));
        } else {
            ctx.sql('(').visit(this.left).sql(' ').visit(Keywords.K_OVERLAPS).sql(' ').visit(this.right).sql(')');
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final Row $arg1() {
        return this.left;
    }

    @Override
    public final Row $arg2() {
        return this.right;
    }

    @Override
    public final Function2<? super Row, ? super Row, ? extends QOM.RowOverlaps> $constructor() {
        return (r1, r2) -> new RowOverlaps((Row2)r1, (Row2)r2);
    }
}

