/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractCondition;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class StartsWithIgnoreCase<T>
extends AbstractCondition
implements QOM.StartsWithIgnoreCase<T> {
    final Field<T> string;
    final Field<T> prefix;

    StartsWithIgnoreCase(Field<T> string, Field<T> prefix) {
        this.string = Tools.nullableIf(false, Tools.nullSafe(string, prefix.getDataType()));
        this.prefix = Tools.nullableIf(false, Tools.nullSafe(prefix, string.getDataType()));
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: 
            case TRINO: {
                ctx.visit(this.string.lower().startsWith(this.prefix.lower()));
                break;
            }
            default: {
                ctx.visit(this.string.likeIgnoreCase(DSL.concat(Tools.escapeForLike(this.prefix, ctx.configuration()), DSL.inline("%")), '!'));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.string;
    }

    @Override
    public final Field<T> $arg2() {
        return this.prefix;
    }

    @Override
    public final QOM.StartsWithIgnoreCase<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.StartsWithIgnoreCase<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.StartsWithIgnoreCase<T>> $constructor() {
        return (a1, a2) -> new StartsWithIgnoreCase(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.StartsWithIgnoreCase) {
            QOM.StartsWithIgnoreCase o = (QOM.StartsWithIgnoreCase)that;
            return Objects.equals(this.$string(), o.$string()) && Objects.equals(this.$prefix(), o.$prefix());
        }
        return super.equals(that);
    }
}

