/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.XML;
import org.neo4j.jdbc.internal.shaded.jooq.XMLAttributes;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartCollectionView;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.impl.XMLAttributesImpl;

final class XMLElement
extends AbstractField<XML>
implements QOM.XMLElement {
    private final Name elementName;
    private final XMLAttributes attributes;
    private final QueryPartList<Field<?>> content;

    XMLElement(Name elementName, XMLAttributes attributes, Collection<? extends Field<?>> content) {
        super(Names.N_XMLELEMENT, SQLDataType.XML);
        this.elementName = elementName;
        this.attributes = attributes == null ? XMLAttributesImpl.EMPTY : attributes;
        this.content = new QueryPartList((Iterable<Field<?>>)content);
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean hasContent = !this.content.isEmpty();
        boolean hasAttributes = !((XMLAttributesImpl)this.attributes).attributes.isEmpty();
        boolean format = hasAttributes || !this.content.isSimple(ctx);
        Consumer<Context> accept0 = c -> {
            c.visit(Keywords.K_NAME).sql(' ').visit(this.elementName);
            if (hasAttributes) {
                if (format) {
                    c.sql(',').formatSeparator().visit(this.attributes);
                } else {
                    c.sql(", ").visit(this.attributes);
                }
            }
            if (hasContent) {
                if (format) {
                    c.sql(',').formatSeparator().visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
                } else {
                    c.sql(", ").visit(QueryPartCollectionView.wrap(this.content).map(XMLElement.xmlCastMapper(ctx)));
                }
            }
        };
        ctx.visit(Names.N_XMLELEMENT).sql('(');
        if (format) {
            ctx.formatIndentStart().formatNewLine().data(Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true, c -> accept0.accept((Context)c)).formatIndentEnd().formatNewLine();
        } else {
            accept0.accept(ctx);
        }
        ctx.sql(')');
    }

    static final Function<? super Field<?>, ? extends Field<?>> xmlCastMapper(Context<?> ctx) {
        return field -> XMLElement.xmlCast(ctx, field);
    }

    static final Field<?> xmlCast(Context<?> ctx, Field<?> field) {
        Field<?> result = field;
        DataType type = field.getDataType();
        switch (ctx.family()) {
            default: 
        }
        if (result != field && Tools.aliased(field) != null) {
            return result.as((Field)field);
        }
        return result;
    }

    @Override
    public final Name $elementName() {
        return this.elementName;
    }

    @Override
    public final XMLAttributes $attributes() {
        return this.attributes;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $content() {
        return QOM.unmodifiable(this.content);
    }
}

