/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.jdbc.values.AbstractMapAccessorWithDefaultValue;
import org.neo4j.jdbc.values.Entity;
import org.neo4j.jdbc.values.IsoDuration;
import org.neo4j.jdbc.values.MapAccessor;
import org.neo4j.jdbc.values.Node;
import org.neo4j.jdbc.values.NotMultiValuedException;
import org.neo4j.jdbc.values.Path;
import org.neo4j.jdbc.values.Point;
import org.neo4j.jdbc.values.Relationship;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.UncoercibleException;
import org.neo4j.jdbc.values.UnsizableException;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;
import org.neo4j.jdbc.values.Vector;

abstract class AbstractValue
extends AbstractMapAccessorWithDefaultValue
implements Value {
    AbstractValue() {
    }

    @Override
    public boolean hasType(Type type) {
        return type.isTypeOf(this);
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isFalse() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean containsKey(String key) {
        throw new NotMultiValuedException(this.type().name() + " is not a keyed collection");
    }

    @Override
    public String asString() {
        throw new UncoercibleException(this.type().name(), "Java String");
    }

    @Override
    public boolean asBoolean(boolean defaultValue) {
        return this.computeOrDefault(Value::asBoolean, defaultValue);
    }

    @Override
    public String asString(String defaultValue) {
        return this.computeOrDefault(Value::asString, defaultValue);
    }

    @Override
    public long asLong(long defaultValue) {
        return this.computeOrDefault(Value::asLong, defaultValue);
    }

    @Override
    public int asInt(int defaultValue) {
        return this.computeOrDefault(Value::asInt, defaultValue);
    }

    @Override
    public double asDouble(double defaultValue) {
        return this.computeOrDefault(Value::asDouble, defaultValue);
    }

    @Override
    public float asFloat(float defaultValue) {
        return this.computeOrDefault(Value::asFloat, Float.valueOf(defaultValue)).floatValue();
    }

    @Override
    public long asLong() {
        throw new UncoercibleException(this.type().name(), "Java long");
    }

    @Override
    public int asInt() {
        throw new UncoercibleException(this.type().name(), "Java int");
    }

    @Override
    public float asFloat() {
        throw new UncoercibleException(this.type().name(), "Java float");
    }

    @Override
    public double asDouble() {
        throw new UncoercibleException(this.type().name(), "Java double");
    }

    @Override
    public boolean asBoolean() {
        throw new UncoercibleException(this.type().name(), "Java boolean");
    }

    @Override
    public List<Object> asList() {
        return this.asList(Value::asObject);
    }

    @Override
    public <T> List<T> asList(Function<Value, T> mapFunction) {
        throw new UncoercibleException(this.type().name(), "Java List");
    }

    @Override
    public Map<String, Object> asMap() {
        return this.asMap(Value::asObject);
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        throw new UncoercibleException(this.type().name(), "Java Map");
    }

    @Override
    public Object asObject() {
        throw new UncoercibleException(this.type().name(), "Java Object");
    }

    @Override
    public <T> T computeOrDefault(Function<Value, T> mapper, T defaultValue) {
        if (this.isNull()) {
            return defaultValue;
        }
        return mapper.apply(this);
    }

    @Override
    public Map<String, Object> asMap(Map<String, Object> defaultValue) {
        return this.computeOrDefault(MapAccessor::asMap, defaultValue);
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction, Map<String, T> defaultValue) {
        return this.computeOrDefault(value -> value.asMap(mapFunction), defaultValue);
    }

    @Override
    public byte[] asByteArray(byte[] defaultValue) {
        return this.computeOrDefault(Value::asByteArray, defaultValue);
    }

    @Override
    public List<Object> asList(List<Object> defaultValue) {
        return this.computeOrDefault(Value::asList, defaultValue);
    }

    @Override
    public <T> List<T> asList(Function<Value, T> mapFunction, List<T> defaultValue) {
        return this.computeOrDefault(value -> value.asList(mapFunction), defaultValue);
    }

    @Override
    public LocalDate asLocalDate(LocalDate defaultValue) {
        return this.computeOrDefault(Value::asLocalDate, defaultValue);
    }

    @Override
    public OffsetTime asOffsetTime(OffsetTime defaultValue) {
        return this.computeOrDefault(Value::asOffsetTime, defaultValue);
    }

    @Override
    public LocalTime asLocalTime(LocalTime defaultValue) {
        return this.computeOrDefault(Value::asLocalTime, defaultValue);
    }

    @Override
    public LocalDateTime asLocalDateTime(LocalDateTime defaultValue) {
        return this.computeOrDefault(Value::asLocalDateTime, defaultValue);
    }

    @Override
    public OffsetDateTime asOffsetDateTime(OffsetDateTime defaultValue) {
        return this.computeOrDefault(Value::asOffsetDateTime, defaultValue);
    }

    @Override
    public ZonedDateTime asZonedDateTime(ZonedDateTime defaultValue) {
        return this.computeOrDefault(Value::asZonedDateTime, defaultValue);
    }

    @Override
    public IsoDuration asIsoDuration(IsoDuration defaultValue) {
        return this.computeOrDefault(Value::asIsoDuration, defaultValue);
    }

    @Override
    public Point asPoint(Point defaultValue) {
        return this.computeOrDefault(Value::asPoint, defaultValue);
    }

    @Override
    public byte[] asByteArray() {
        throw new UncoercibleException(this.type().name(), "Byte array");
    }

    @Override
    public Number asNumber() {
        throw new UncoercibleException(this.type().name(), "Java Number");
    }

    @Override
    public Entity asEntity() {
        throw new UncoercibleException(this.type().name(), "Entity");
    }

    @Override
    public Node asNode() {
        throw new UncoercibleException(this.type().name(), "Node");
    }

    @Override
    public Path asPath() {
        throw new UncoercibleException(this.type().name(), "Path");
    }

    @Override
    public Relationship asRelationship() {
        throw new UncoercibleException(this.type().name(), "Relationship");
    }

    @Override
    public LocalDate asLocalDate() {
        throw new UncoercibleException(this.type().name(), "LocalDate");
    }

    @Override
    public OffsetTime asOffsetTime() {
        throw new UncoercibleException(this.type().name(), "OffsetTime");
    }

    @Override
    public LocalTime asLocalTime() {
        throw new UncoercibleException(this.type().name(), "LocalTime");
    }

    @Override
    public LocalDateTime asLocalDateTime() {
        throw new UncoercibleException(this.type().name(), "LocalDateTime");
    }

    @Override
    public OffsetDateTime asOffsetDateTime() {
        throw new UncoercibleException(this.type().name(), "OffsetDateTime");
    }

    @Override
    public ZonedDateTime asZonedDateTime() {
        throw new UncoercibleException(this.type().name(), "ZonedDateTime");
    }

    @Override
    public IsoDuration asIsoDuration() {
        throw new UncoercibleException(this.type().name(), "Duration");
    }

    @Override
    public Point asPoint() {
        throw new UncoercibleException(this.type().name(), "Point");
    }

    @Override
    public Vector asVector() {
        throw new UncoercibleException(this.type().name(), "Vector");
    }

    @Override
    public Value get(int index) {
        throw new NotMultiValuedException(this.type().name() + " is not an indexed collection");
    }

    @Override
    public Value get(String key) {
        throw new NotMultiValuedException(this.type().name() + " is not a keyed collection");
    }

    @Override
    public int size() {
        throw new UnsizableException(this.type().name() + " does not have size");
    }

    @Override
    public Iterable<String> keys() {
        return Collections.emptyList();
    }

    @Override
    public boolean isEmpty() {
        return !this.values().iterator().hasNext();
    }

    @Override
    public Iterable<Value> values() {
        return this.values(Values.ofValue());
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        throw new NotMultiValuedException(this.type().name() + " is not iterable");
    }

    @Override
    public abstract boolean equals(Object var1);

    @Override
    public abstract int hashCode();

    @Override
    public abstract String toString();
}

