/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.util.Iterator;
import org.neo4j.jdbc.AbstractCursor;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jTransaction;
import org.neo4j.jdbc.values.Record;

final class BoltCursor
extends AbstractCursor {
    private final Neo4jTransaction transaction;
    private final Neo4jTransaction.RunResponse runResponse;
    private final Runnable onNextBatch;
    private int fetchSize;
    private int remainingRowAllowance;
    private Iterator<Record> currentBatch;
    private Neo4jTransaction.PullResponse currentBatchResponse;

    BoltCursor(Record sampleRecord, Neo4jTransaction transaction, Neo4jTransaction.RunResponse runResponse, int remainingRowAllowance, int fetchSize, Neo4jTransaction.PullResponse currentBatchResponse, Iterator<Record> currentBatch, Runnable onNextBatch) {
        super(sampleRecord);
        this.transaction = transaction;
        this.runResponse = runResponse;
        this.onNextBatch = onNextBatch;
        this.fetchSize = fetchSize;
        this.remainingRowAllowance = remainingRowAllowance;
        this.currentBatchResponse = currentBatchResponse;
        this.currentBatch = currentBatch;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.remainingRowAllowance == 0) {
            return false;
        }
        if (this.currentBatch.hasNext()) {
            return this.pullNext();
        }
        if (this.currentBatchResponse.hasMore()) {
            this.currentBatchResponse = this.transaction.pull(this.runResponse, this.calculateFetchSize());
            this.currentBatch = this.currentBatchResponse.records().iterator();
            this.onNextBatch.run();
            return this.pullNext();
        }
        this.currentRecord = null;
        return false;
    }

    @Override
    public boolean isLast() {
        return this.currentBatch.hasNext() || this.currentBatchResponse.hasMore();
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        if (fetchSize <= 0) {
            throw new Neo4jException(Neo4jException.GQLError.$22N02.withTemplatedMessage("fetch size", fetchSize));
        }
        this.fetchSize = fetchSize;
    }

    @Override
    public void close() throws SQLException {
        if (this.transaction.isAutoCommit() && this.transaction.isRunnable()) {
            this.transaction.commit();
        }
    }

    private boolean pullNext() {
        this.currentRecord = this.currentBatch.next();
        ++this.currentRowNum;
        this.decrementRemainingRowAllowance();
        return this.currentRecord != null;
    }

    private int calculateFetchSize() {
        return this.remainingRowAllowance > 0 ? Math.min(this.remainingRowAllowance, this.fetchSize) : this.fetchSize;
    }

    private void decrementRemainingRowAllowance() {
        if (this.remainingRowAllowance > 0) {
            --this.remainingRowAllowance;
        }
    }
}

