/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Events {
    private static final Logger LOGGER = Logger.getLogger("org.neo4j.jdbc.events");

    static <T> void notify(Collection<T> listeners, Consumer<T> consumer) {
        listeners.forEach(listener -> {
            try {
                consumer.accept(listener);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex, () -> "Could not notify listener %s".formatted(listener.getClass().getCanonicalName()));
            }
        });
    }

    static URI cleanURL(URI jdbcUrl) {
        URI hlp = URI.create(jdbcUrl.getSchemeSpecificPart());
        try {
            int port = hlp.getPort();
            return new URI("jdbc", "%s://%s:%d%s".formatted(hlp.getScheme(), hlp.getHost(), port != -1 ? port : 7687, hlp.getPath()), jdbcUrl.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Events() {
    }
}

