/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.jdbc.MetricsCollectorImpl;
import org.neo4j.jdbc.events.ConnectionListener;
import org.neo4j.jdbc.events.DriverListener;
import org.neo4j.jdbc.events.StatementListener;

interface MetricsCollector
extends DriverListener,
ConnectionListener,
StatementListener {
    public static final AtomicBoolean GLOBAL_REGISTRY_HAS_BEEN_TRIED = new AtomicBoolean(false);

    public static Optional<MetricsCollector> tryGlobal() {
        CompositeMeterRegistry globalRegistry;
        try {
            globalRegistry = Metrics.globalRegistry;
        }
        catch (Throwable ex) {
            if (GLOBAL_REGISTRY_HAS_BEEN_TRIED.compareAndSet(false, true)) {
                Logger.getLogger("org.neo4j.jdbc").log(Level.FINE, "Metrics are not available");
            }
            return Optional.empty();
        }
        return Optional.of(MetricsCollectorImpl.of((MeterRegistry)globalRegistry));
    }
}

