/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.net.URI;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.jdbc.Events;
import org.neo4j.jdbc.MetricsCollector;
import org.neo4j.jdbc.events.ConnectionListener;
import org.neo4j.jdbc.events.DriverListener;
import org.neo4j.jdbc.events.StatementListener;

final class MetricsCollectorImpl
implements MetricsCollector {
    private static final Map<MeterRegistry, MetricsCollector> INSTANCES = new ConcurrentHashMap<MeterRegistry, MetricsCollector>();
    private final MeterRegistry meterRegistry;
    private final Map<URI, GaugeBackend> openConnections = new ConcurrentHashMap<URI, GaugeBackend>();
    private final Map<StatementKey, GaugeBackend> openStatements = new ConcurrentHashMap<StatementKey, GaugeBackend>();
    private final GaugeBackend cachedTranslations = new GaugeBackend("org.neo4j.jdbc.cached-translations", "The number of cached statement translations", new Tag[0]);

    static MetricsCollector of(MeterRegistry meterRegistry) {
        return INSTANCES.computeIfAbsent(meterRegistry, MetricsCollectorImpl::new);
    }

    private MetricsCollectorImpl(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onNewAuthentication(ConnectionListener.NewAuthenticationEvent event) {
        String uri = Events.cleanURL(event.uri()).toString();
        String authentications = "org.neo4j.jdbc.authentications";
        Counter counter = switch (event.state()) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionListener.NewAuthenticationEvent.State.NEW -> this.getOrCreateCounter(authentications, List.of(Tag.of((String)"uri", (String)uri), Tag.of((String)"state", (String)"new")), "The total number of new authentications acquired");
            case ConnectionListener.NewAuthenticationEvent.State.REFRESHED -> this.getOrCreateCounter(authentications, List.of(Tag.of((String)"uri", (String)uri), Tag.of((String)"state", (String)"refreshed")), "The total number of authentications refreshed");
        };
        counter.increment();
    }

    @Override
    public void onConnectionOpened(DriverListener.ConnectionOpenedEvent event) {
        GaugeBackend gauge = this.openConnections.computeIfAbsent(Events.cleanURL(event.uri()), key -> new GaugeBackend("org.neo4j.jdbc.connections", "The number of currently open connections", Tag.of((String)"uri", (String)key.toString())));
        gauge.registerGauge(this.meterRegistry);
        gauge.increment();
    }

    @Override
    public void onConnectionClosed(DriverListener.ConnectionClosedEvent event) {
        GaugeBackend counterAndTags = this.openConnections.get(Events.cleanURL(event.uri()));
        if (counterAndTags != null) {
            counterAndTags.decrement();
        }
    }

    @Override
    public void onStatementCreated(ConnectionListener.StatementCreatedEvent event) {
        GaugeBackend gauge = this.openStatements.computeIfAbsent(new StatementKey(Events.cleanURL(event.uri()), event.statementType()), key -> new GaugeBackend("org.neo4j.jdbc.statements", "The number of currently open statements", Tag.of((String)"uri", (String)key.uri().toString()), Tag.of((String)"type", (String)key.type().getSimpleName())));
        gauge.registerGauge(this.meterRegistry);
        gauge.increment();
    }

    @Override
    public void onStatementClosed(ConnectionListener.StatementClosedEvent event) {
        GaugeBackend counterWithTags = this.openStatements.get(new StatementKey(Events.cleanURL(event.uri()), event.statementType()));
        if (counterWithTags != null) {
            counterWithTags.decrement();
        }
    }

    @Override
    public void onTranslationCached(ConnectionListener.TranslationCachedEvent event) {
        this.cachedTranslations.registerGauge(this.meterRegistry);
        this.cachedTranslations.set(event.cacheSize());
    }

    @Override
    public void onExecutionEnded(StatementListener.ExecutionEndedEvent event) {
        String uri = Events.cleanURL(event.uri()).toString();
        String queries = "org.neo4j.jdbc.queries";
        this.getOrCreateTimer(queries, List.of(Tag.of((String)"uri", (String)uri), Tag.of((String)"state", (String)event.state().name().toLowerCase(Locale.ROOT))), "Duration of the queries being run").record(event.elapsedTime());
    }

    private Counter getOrCreateCounter(String name, List<Tag> tags, String description) {
        Counter counter = this.meterRegistry.find(name).tags(tags).counter();
        if (counter == null) {
            counter = Counter.builder((String)name).description(description).tags(tags).register(this.meterRegistry);
        }
        return counter;
    }

    private Timer getOrCreateTimer(String name, List<Tag> tags, String description) {
        Timer timer = this.meterRegistry.find(name).tags(tags).timer();
        if (timer == null) {
            timer = Timer.builder((String)name).description(description).tags(tags).register(this.meterRegistry);
        }
        return timer;
    }

    public record GaugeBackend(String name, String description, AtomicInteger counter, List<Tag> tags) {
        GaugeBackend(String name, String description, Tag ... tags) {
            this(name, description, new AtomicInteger(), List.of(tags));
        }

        void increment() {
            this.counter.incrementAndGet();
        }

        void decrement() {
            this.counter.decrementAndGet();
        }

        int get() {
            return this.counter.get();
        }

        void set(int newValue) {
            this.counter.set(newValue);
        }

        void registerGauge(MeterRegistry meterRegistry) {
            Gauge meter = meterRegistry.find(this.name).tags(this.tags).gauge();
            if (meter != null) {
                return;
            }
            Gauge.builder((String)this.name, this::get).description(this.description).tags(this.tags).register(meterRegistry);
        }
    }

    public record StatementKey(URI uri, Class<? extends Statement> type) {
    }
}

