/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.neo4j.jdbc.Neo4jConversions;
import org.neo4j.jdbc.Neo4jException;

class ParameterMetaDataImpl
implements ParameterMetaData {
    private final int parameterCount;
    private final Map<Integer, String> parameterTypes;

    ParameterMetaDataImpl(int parameterCount) {
        this.parameterCount = parameterCount;
        this.parameterTypes = Map.of();
    }

    ParameterMetaDataImpl(Map<Integer, String> parameterTypes) {
        this.parameterCount = parameterTypes.size();
        this.parameterTypes = Map.copyOf(parameterTypes);
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int param) {
        return 2;
    }

    @Override
    public boolean isSigned(int param) {
        return false;
    }

    @Override
    public int getPrecision(int param) {
        return 0;
    }

    @Override
    public int getScale(int param) {
        return 0;
    }

    @Override
    public int getParameterType(int param) {
        return Neo4jConversions.toSqlTypeFromOldCypherType(this.parameterTypes.get(param));
    }

    @Override
    public String getParameterTypeName(int param) {
        return Neo4jConversions.oldCypherTypesToNew(this.parameterTypes.get(param));
    }

    @Override
    public String getParameterClassName(int param) {
        return null;
    }

    @Override
    public int getParameterMode(int param) {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new Neo4jException(Neo4jException.withReason("This object does not implement the given interface"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }
}

