/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.jdbc.JSONMappers;
import org.neo4j.jdbc.Neo4jConversions;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jPreparedStatement;
import org.neo4j.jdbc.Neo4jTransactionSupplier;
import org.neo4j.jdbc.ParameterMetaDataImpl;
import org.neo4j.jdbc.StatementImpl;
import org.neo4j.jdbc.Warnings;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.ValueException;
import org.neo4j.jdbc.values.Values;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class PreparedStatementImpl
extends StatementImpl
implements Neo4jPreparedStatement {
    private static final Logger LOGGER = Logger.getLogger("org.neo4j.jdbc.prepared-statement");
    private static final Pattern SQL_PLACEHOLDER_PATTERN = Pattern.compile("\\?(?=(?:[^\"']*[\"'][^\"']*[\"'])*[^\"']*$)");
    private final Deque<Map<String, Object>> parameters = new ArrayDeque<Map<String, Object>>();
    private final boolean rewriteBatchedStatements;
    private final String sql;
    private final AtomicBoolean cursorMoved = new AtomicBoolean(false);
    private final int autoGeneratedKeys;

    static String rewritePlaceholders(String raw) {
        int index = 1;
        Matcher matcher = SQL_PLACEHOLDER_PATTERN.matcher(raw);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "\\$" + index++);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    PreparedStatementImpl(Connection connection, Neo4jTransactionSupplier transactionSupplier, UnaryOperator<String> translator, Warnings localWarnings, Consumer<Class<? extends Statement>> onClose, boolean rewritePlaceholders, boolean rewriteBatchedStatements, int autoGeneratedKeys, String sql) {
        super(connection, transactionSupplier, rewritePlaceholders ? s -> PreparedStatementImpl.rewritePlaceholders((String)translator.apply(s)) : translator, localWarnings, onClose);
        this.rewriteBatchedStatements = rewriteBatchedStatements;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.sql = sql;
        this.poolable = true;
        this.parameters.add(PreparedStatementImpl.newParameterMap());
    }

    private static LinkedHashMap<String, Object> newParameterMap() {
        return new LinkedHashMap<String, Object>();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Executing query");
        this.assertIsOpen();
        return super.executeQuery0(this.sql, true, this.getCurrentBatch());
    }

    protected final Map<String, Object> getCurrentBatch() {
        return this.parameters.getLast();
    }

    @Override
    public int executeUpdate() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Executing update");
        this.assertIsOpen();
        return super.executeUpdate0(this.sql, true, this.getCurrentBatch(), this.autoGeneratedKeys);
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public void addBatch() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Adding batch");
        this.assertIsOpen();
        this.parameters.addLast(PreparedStatementImpl.newParameterMap());
    }

    @Override
    public void clearParameters() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Clearing parameters");
        this.assertIsOpen();
        this.getCurrentBatch().clear();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] result;
        LOGGER.log(Level.FINER, () -> "Executing batch");
        this.assertIsOpen();
        Object processedSql = this.processSQL(this.sql);
        if (this.rewriteBatchedStatements) {
            HashSet<String> keys = new HashSet<String>();
            ArrayList<Map<String, Object>> validParameters = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> parameter : this.parameters) {
                if (parameter.isEmpty()) continue;
                keys.addAll(parameter.keySet());
                validParameters.add(parameter);
            }
            for (String key : keys.stream().sorted(Comparator.comparing(String::length).reversed()).toList()) {
                processedSql = ((String)processedSql).replaceAll(Pattern.quote("$" + key) + "(?!\\d)", "__parameter['" + key + "']");
            }
            processedSql = "UNWIND $__parameters AS __parameter " + (String)processedSql;
            LOGGER.log(Level.INFO, "Rewrite batch statements is in effect, statement {0} has been rewritten into {1}", new Object[]{this.sql, processedSql});
            result = new int[]{super.executeUpdate0((String)processedSql, false, Map.of("__parameters", validParameters), this.autoGeneratedKeys)};
        } else {
            result = new int[this.parameters.size()];
            Arrays.fill(result, -2);
            int i = 0;
            for (Map<String, Object> parameter : this.parameters) {
                if (parameter.isEmpty()) continue;
                result[i++] = super.executeUpdate0((String)processedSql, false, parameter, this.autoGeneratedKeys);
            }
        }
        this.clearBatch();
        return result;
    }

    @Override
    public void clearBatch() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Clearing batch");
        this.assertIsOpen();
        this.parameters.clear();
        this.parameters.add(PreparedStatementImpl.newParameterMap());
    }

    final void setParameter(String key, Object value) {
        LOGGER.log(Level.FINER, () -> {
            String type;
            String valueLogged;
            if (value != null) {
                valueLogged = "******";
                if (value instanceof Value) {
                    Value hlp = (Value)value;
                    type = hlp.type().name();
                } else {
                    type = value.getClass().getName();
                }
            } else {
                valueLogged = "(literal) null";
                type = Void.class.getName();
            }
            return "Setting parameter `%s` to `%s` (%s)".formatted(key, valueLogged, type);
        });
        this.getCurrentBatch().put(Objects.requireNonNull(key), value);
    }

    @Override
    public final int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final long executeLargeUpdate(String sql) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public final long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw this.newIllegalMethodInvocation();
    }

    @Override
    public void setNull(int parameterIndex, int ignored) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.NULL);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value((int)x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value((int)x));
    }

    @Override
    public void setInt(String parameterName, int value) throws SQLException {
        this.assertIsOpen();
        Objects.requireNonNull(parameterName);
        this.setParameter(parameterName, Values.value(value));
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(value));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value((double)x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), x != null ? Values.value(x.toString()) : Values.NULL);
    }

    @Override
    public void setString(String parameterName, String string) throws SQLException {
        this.assertIsOpen();
        Objects.requireNonNull(parameterName);
        Objects.requireNonNull(string);
        this.setParameter(parameterName, Values.value(string));
    }

    @Override
    public void setString(int parameterIndex, String string) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(string));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(Objects.requireNonNull(bytes)));
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(value.toLocalDate()));
    }

    @Override
    public void setDate(String parameterName, Date value) throws SQLException {
        this.assertIsOpen();
        Objects.requireNonNull(value);
        this.setParameter(parameterName, Values.value(value.toLocalDate()));
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(value.toLocalTime()));
    }

    @Override
    public void setTime(String parameterName, Time value) throws SQLException {
        this.assertIsOpen();
        Objects.requireNonNull(value);
        this.setParameter(parameterName, Values.value(value.toLocalTime()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.value(value.toLocalDateTime()));
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value(Objects.requireNonNull(value).toLocalDateTime()));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        PreparedStatementImpl.assertValidStreamLength("character", parameterIndex, length);
        this.setAsciiStream0(PreparedStatementImpl.computeParameterName(parameterIndex), inputStream, length);
    }

    private static void assertValidStreamLength(String name, int parameterIndex, int length) throws SQLException {
        if (length < 0) {
            throw new Neo4jException(Neo4jException.GQLError.$22N02.withMessage("Invalid length %d for %s stream at index %d".formatted(length, name, parameterIndex)));
        }
    }

    final void setAsciiStream0(String parameterName, InputStream inputStream, int length) throws SQLException {
        byte[] bytes;
        try (InputStream in = Objects.requireNonNull(inputStream);){
            bytes = in.readNBytes(length);
        }
        catch (IOException ex) {
            throw new Neo4jException(Neo4jException.withInternal(ex));
        }
        this.setParameter(parameterName, Values.value(new String(bytes, DEFAULT_ASCII_CHARSET_FOR_INCOMING_STREAM)));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x, StandardCharsets.UTF_8), length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        PreparedStatementImpl.assertValidStreamLength("binary", parameterIndex, length);
        this.setBinaryStream0(PreparedStatementImpl.computeParameterName(parameterIndex), inputStream, length);
    }

    final void setBinaryStream0(String parameterName, InputStream inputStream, int length) throws SQLException {
        byte[] bytes;
        try (InputStream in = Objects.requireNonNull(inputStream);){
            bytes = in.readNBytes(length);
        }
        catch (IOException ex) {
            throw new Neo4jException(Neo4jException.withInternal(ex));
        }
        this.setParameter(parameterName, Values.value(bytes));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setObjectParameter(PreparedStatementImpl.computeParameterName(parameterIndex), value);
    }

    @Override
    public void setObject(String parameterName, Object value) throws SQLException {
        this.assertIsOpen();
        this.setObjectParameter(parameterName, value);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, reader);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream stream) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, new InputStreamReader(stream, DEFAULT_ASCII_CHARSET_FOR_INCOMING_STREAM));
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream stream) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, stream);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.NULL);
    }

    @Override
    public void setBoolean(String parameterName, boolean value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value(value));
    }

    @Override
    public void setByte(String parameterName, byte value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value((int)value));
    }

    @Override
    public void setShort(String parameterName, short value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value((int)value));
    }

    @Override
    public void setLong(String parameterName, long value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value(value));
    }

    @Override
    public void setFloat(String parameterName, float value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value((double)value));
    }

    @Override
    public void setDouble(String parameterName, double value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value(value));
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal value) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, value != null ? Values.value(value.toString()) : Values.NULL);
    }

    @Override
    public void setBytes(String parameterName, byte[] bytes) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value(Objects.requireNonNull(bytes)));
    }

    private void setObjectParameter(String parameterName, Object value) throws SQLException {
        if (value instanceof Date) {
            Date date = (Date)value;
            this.setDate(parameterName, date);
        } else if (value instanceof Time) {
            Time time = (Time)value;
            this.setTime(parameterName, time);
        } else if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            this.setTimestamp(parameterName, timestamp);
        } else if (value instanceof Value) {
            Value neo4jValue = (Value)value;
            this.setParameter(parameterName, neo4jValue);
        } else {
            Optional<Value> optionalJSONMapper = Optional.ofNullable(value).map(Object::getClass).flatMap(type -> JSONMappers.INSTANCE.getMapper(type.getName()));
            try {
                this.setParameter(parameterName, optionalJSONMapper.map(mapper -> mapper.fromJson(value)).orElseGet(() -> Values.value(value)));
            }
            catch (ValueException ex) {
                throw new Neo4jException(Neo4jException.withInternal(ex));
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Executing");
        return super.execute0(this.sql, this.getCurrentBatch(), this.autoGeneratedKeys);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        PreparedStatementImpl.assertValidStreamLength("character", parameterIndex, length);
        this.setCharacterStream0(PreparedStatementImpl.computeParameterName(parameterIndex), reader, length);
    }

    final void setCharacterStream0(String parameterName, Reader reader, int length) throws SQLException {
        int lengthRead;
        char[] charBuffer = new char[length];
        try (Reader in = Objects.requireNonNull(reader);){
            lengthRead = in.read(charBuffer, 0, length);
        }
        catch (IOException ex) {
            throw new Neo4jException(Neo4jException.withInternal(ex));
        }
        this.setParameter(parameterName, Values.value(lengthRead != -1 ? new String(charBuffer, 0, lengthRead) : ""));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setArray0(PreparedStatementImpl.computeParameterName(parameterIndex), x);
    }

    @Override
    public void setArray(String parameterName, Array x) throws SQLException {
        this.assertIsOpen();
        Objects.requireNonNull(parameterName);
        this.setArray0(parameterName, x);
    }

    private void setArray0(String parameterName, Array x) throws SQLException {
        Value value;
        if (x == null) {
            this.setParameter(parameterName, Values.NULL);
            return;
        }
        if ("BYTES".equals(x.getBaseTypeName())) {
            value = Values.value(x.getArray());
        } else {
            ArrayList<Value> hlp = new ArrayList<Value>();
            try (ResultSet rs = x.getResultSet();){
                while (rs.next()) {
                    hlp.add(rs.getObject(2, Value.class));
                }
            }
            value = Values.value(hlp);
        }
        this.setParameter(parameterName, value);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting meta data");
        if (this.resultSet == null) {
            throw new Neo4jException(Neo4jException.withReason("#execute has not been called"));
        }
        if (this.cursorMoved.compareAndSet(false, true)) {
            this.resultSet.value().next();
        }
        return this.resultSet.value().getMetaData();
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setDate0(PreparedStatementImpl.computeParameterName(parameterIndex), date, cal);
    }

    protected final void setDate0(String parameterName, Date date, Calendar cal) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Values.value((Object)Neo4jConversions.asValue(date, cal)));
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setTime0(PreparedStatementImpl.computeParameterName(parameterIndex), time, cal);
    }

    protected final void setTime0(String parameterName, Time time, Calendar cal) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Neo4jConversions.asValue(time, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestamp, Calendar cal) throws SQLException {
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setTimestamp0(PreparedStatementImpl.computeParameterName(parameterIndex), timestamp, cal);
    }

    protected final void setTimestamp0(String parameterName, Timestamp timestamp, Calendar cal) throws SQLException {
        this.assertIsOpen();
        this.setParameter(parameterName, Neo4jConversions.asValue(timestamp, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), Values.NULL);
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), url != null ? Values.value(url.toString()) : Values.NULL);
    }

    @Override
    public ParameterMetaData getParameterMetaData() {
        LOGGER.log(Level.FINER, () -> "Getting parameter meta data");
        return new ParameterMetaDataImpl(this.getCurrentBatch().size());
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(1, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setAsciiStream(parameterIndex, inputStream, PreparedStatementImpl.getLengthAsInt(length));
    }

    static int getLengthAsInt(long length) throws SQLException {
        int lengthAsInt = (int)length;
        if ((long)lengthAsInt != length) {
            throw new Neo4jException(Neo4jException.GQLError.$22003.withTemplatedMessage(length));
        }
        return lengthAsInt;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, PreparedStatementImpl.getLengthAsInt(length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, PreparedStatementImpl.getLengthAsInt(length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream stream) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), new InputStreamReader(stream, DEFAULT_ASCII_CHARSET_FOR_INCOMING_STREAM));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.assertIsOpen();
        PreparedStatementImpl.assertValidParameterIndex(parameterIndex);
        this.setParameter(PreparedStatementImpl.computeParameterName(parameterIndex), reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private static String computeParameterName(int parameterIndex) {
        return String.valueOf(parameterIndex);
    }

    SQLException newIllegalMethodInvocation() {
        return new Neo4jException(Neo4jException.withReason("This method must not be called on %s".formatted(this.getClass().getSimpleName().replace("Impl", ""))));
    }

    private static void assertValidParameterIndex(int index) throws SQLException {
        if (index < 1) {
            throw new Neo4jException(Neo4jException.GQLError.$22003.withMessage("Parameter index must be equal or more than 1"));
        }
    }

    protected void setURL(String parameterName, URL value) throws SQLException {
        this.assertIsOpen();
        Objects.requireNonNull(parameterName);
        this.setParameter(parameterName, value != null ? Values.value(value.toString()) : Values.NULL);
    }
}

