/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.jdbc.Events;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Neo4jException;
import org.neo4j.jdbc.Neo4jResultSet;
import org.neo4j.jdbc.Neo4jStatement;
import org.neo4j.jdbc.Neo4jTransaction;
import org.neo4j.jdbc.Neo4jTransactionSupplier;
import org.neo4j.jdbc.ResultSetImpl;
import org.neo4j.jdbc.Warnings;
import org.neo4j.jdbc.events.Neo4jEvent;
import org.neo4j.jdbc.events.ResultSetListener;
import org.neo4j.jdbc.events.StatementListener;
import org.neo4j.jdbc.internal.shaded.bolt.SummaryCounters;
import org.neo4j.jdbc.internal.shaded.schema_name.SchemaNames;
import org.neo4j.jdbc.values.Record;
import org.neo4j.jdbc.values.Values;

class StatementImpl
implements Neo4jStatement {
    private static final Logger LOGGER = Logger.getLogger("org.neo4j.jdbc.statement");
    private static final Logger SQL_LOGGER = Logger.getLogger("org.neo4j.jdbc.statement.SQL");
    private static final Map<String, AtomicLong> ID_GENERATORS = new ConcurrentHashMap<String, AtomicLong>();
    static final int DEFAULT_BUFFER_SIZE_FOR_INCOMING_STREAMS = 4096;
    static final Charset DEFAULT_ASCII_CHARSET_FOR_INCOMING_STREAM = StandardCharsets.ISO_8859_1;
    private static final HexFormat HEX_FORMAT = HexFormat.of();
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private final Connection connection;
    private final Neo4jTransactionSupplier transactionSupplier;
    private int fetchSize = 1000;
    private int maxRows;
    private int maxFieldSize;
    protected ResultSetHolder resultSet;
    private int updateCount = -1;
    private boolean multipleResultsApi;
    private int queryTimeout;
    protected boolean poolable;
    private boolean closeOnCompletion;
    private boolean closed;
    private final UnaryOperator<String> sqlProcessor;
    private final Warnings warnings;
    private final AtomicBoolean resultSetAcquired = new AtomicBoolean(false);
    private final Map<String, Object> transactionMetadata = new ConcurrentHashMap<String, Object>();
    private final Consumer<Class<? extends Statement>> onClose;
    private final Set<StatementListener> listeners = new HashSet<StatementListener>();

    StatementImpl(Connection connection, Neo4jTransactionSupplier transactionSupplier, UnaryOperator<String> sqlProcessor, Warnings localWarnings, Consumer<Class<? extends Statement>> onClose) {
        this.connection = Objects.requireNonNull(connection);
        this.transactionSupplier = Objects.requireNonNull(transactionSupplier);
        this.sqlProcessor = Objects.requireNonNullElseGet(sqlProcessor, UnaryOperator::identity);
        this.warnings = Objects.requireNonNullElseGet(localWarnings, Warnings::new);
        this.onClose = Objects.requireNonNullElse(onClose, type -> {});
    }

    StatementImpl() {
        this.connection = null;
        this.transactionSupplier = null;
        this.sqlProcessor = UnaryOperator.identity();
        this.warnings = new Warnings();
        this.onClose = type -> {};
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery0(sql, true, Map.of());
    }

    protected final ResultSet executeQuery0(String sql, boolean applyProcessor, Map<String, Object> parameters) throws SQLException {
        this.assertIsOpen();
        this.closeResultSet();
        return this.recordEvent(sql, StatementListener.ExecutionStartedEvent.ExecutionMode.QUERY, context -> {
            this.updateCount = -1;
            this.multipleResultsApi = false;
            String processedSQL = applyProcessor ? this.processSQL(sql) : sql;
            Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.SQL_PROCESSED, context)));
            Neo4jTransaction transaction = this.transactionSupplier.getTransaction(this.transactionMetadata);
            Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.TRANSACTION_ACQUIRED, context)));
            Neo4jTransaction.RunAndPullResponses responses = this.runAndPull(transaction, processedSQL, parameters, context);
            this.resultSet = this.newResultSet(transaction, responses, Kind.DEFAULT);
            this.resultSetAcquired.set(false);
            return this.resultSet.value();
        });
    }

    private Neo4jTransaction.RunAndPullResponses runAndPull(Neo4jTransaction transaction, String processedSQL, Map<String, Object> parameters, Map<String, Object> context) throws SQLException {
        int finalFetchSize = this.maxRows > 0 ? Math.min(this.maxRows, this.fetchSize) : this.fetchSize;
        Neo4jTransaction.RunAndPullResponses runAndPull = transaction.runAndPull(processedSQL, StatementImpl.getParameters(parameters), finalFetchSize, this.queryTimeout);
        Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.RUN_AND_PULL_RESPONSE_ACQUIRED, context)));
        return runAndPull;
    }

    private ResultSetHolder newResultSet(Neo4jTransaction transaction, Neo4jTransaction.RunAndPullResponses responses, Kind kind) {
        ResultSetImpl newResultSet = new ResultSetImpl(this, this.maxFieldSize, transaction, responses.runResponse(), responses.pullResponse(), this.fetchSize, this.maxRows);
        this.listeners.forEach(listener -> {
            if (listener instanceof ResultSetListener) {
                ResultSetListener resultSetListener = (ResultSetListener)((Object)listener);
                newResultSet.addListener(resultSetListener);
            }
        });
        return new ResultSetHolder(newResultSet, kind);
    }

    private ResultSetHolder newResultSet(List<Record> records, Kind kind) {
        ResultSetImpl newResultSet = new ResultSetImpl(this, this.maxFieldSize, records);
        this.listeners.forEach(listener -> {
            if (listener instanceof ResultSetListener) {
                ResultSetListener resultSetListener = (ResultSetListener)((Object)listener);
                newResultSet.addListener(resultSetListener);
            }
        });
        return new ResultSetHolder(newResultSet, kind);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Executing update with auto generated keys set to %d".formatted(autoGeneratedKeys));
        return this.executeUpdate0(sql, true, Map.of(), autoGeneratedKeys);
    }

    protected final int executeUpdate0(String sql, boolean applyProcessor, Map<String, Object> parameters, int autoGeneratedKeys) throws SQLException {
        boolean returnGeneratedKeys;
        this.assertIsOpen();
        StatementImpl.assertAutoGeneratedKeys(autoGeneratedKeys);
        ArrayList<Record> records = new ArrayList<Record>();
        boolean bl = returnGeneratedKeys = autoGeneratedKeys == 1;
        if (returnGeneratedKeys) {
            records.addAll(StatementImpl.pullAllGeneratedKeys(this.resultSet));
        }
        this.closeResultSet();
        return this.recordEvent(sql, StatementListener.ExecutionStartedEvent.ExecutionMode.UPDATE, context -> {
            Optional<SummaryCounters> counters;
            this.updateCount = -1;
            this.multipleResultsApi = false;
            String processedSQL = applyProcessor ? this.processSQL(sql) : sql;
            Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.SQL_PROCESSED, context)));
            Neo4jTransaction transaction = this.transactionSupplier.getTransaction(this.transactionMetadata);
            Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.TRANSACTION_ACQUIRED, context)));
            if (returnGeneratedKeys) {
                Neo4jTransaction.RunAndPullResponses responses = this.runAndPull(transaction, processedSQL, parameters, context);
                ResultSetHolder nextResultSet = this.newResultSet(transaction, responses, Kind.GENERATED_KEYS);
                if (records.isEmpty()) {
                    this.resultSet = nextResultSet;
                } else {
                    records.addAll(StatementImpl.pullAllGeneratedKeys(nextResultSet));
                    this.resultSet = this.newResultSet(records, Kind.GENERATED_KEYS);
                }
                this.resultSetAcquired.set(false);
                counters = responses.pullResponse().resultSummary().map(Neo4jTransaction.ResultSummary::counters);
            } else {
                Neo4jTransaction.DiscardResponse discardResponse = transaction.runAndDiscard(processedSQL, StatementImpl.getParameters(parameters), this.queryTimeout, transaction.isAutoCommit());
                Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.DISCARD_RESPONSE_ACQUIRED, context)));
                counters = discardResponse.resultSummary().map(Neo4jTransaction.ResultSummary::counters);
            }
            return counters.map(StatementImpl::countUpdates).orElse(0);
        });
    }

    private static Integer countUpdates(SummaryCounters c) {
        int rowCount = c.nodesCreated() + c.nodesDeleted() + c.relationshipsCreated() + c.relationshipsDeleted();
        if (rowCount == 0 && c.containsUpdates()) {
            int labelsAndProperties = c.labelsAdded() + c.labelsRemoved() + c.propertiesSet();
            rowCount = labelsAndProperties > 0 ? 1 : 0;
        }
        return rowCount;
    }

    private static List<Record> pullAllGeneratedKeys(ResultSetHolder holder) throws SQLException {
        ArrayList<Record> records = new ArrayList<Record>();
        if (holder != null && holder.kind() == Kind.GENERATED_KEYS) {
            try (Neo4jResultSet rs = holder.value().unwrap(Neo4jResultSet.class);){
                while (rs.next()) {
                    records.add(rs.getCurrentRecord());
                }
            }
        }
        return records;
    }

    @Override
    public void close() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Closing");
        if (this.closed) {
            return;
        }
        this.closeResultSet();
        this.closed = true;
        this.onClose.accept(this.getType());
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting max field size");
        this.assertIsOpen();
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Setting max field size to %d".formatted(max));
        this.assertIsOpen();
        if (max < 0) {
            throw new Neo4jException(Neo4jException.GQLError.$22N02.withTemplatedMessage("max field size", max));
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting max rows");
        this.assertIsOpen();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Setting max rows to %d".formatted(max));
        this.assertIsOpen();
        if (max < 0) {
            throw new Neo4jException(Neo4jException.GQLError.$22N02.withTemplatedMessage("max rows", max));
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean ignored) throws SQLException {
        LOGGER.log(Level.WARNING, () -> "Setting escape processing to %s (ignored)".formatted(ignored));
        this.assertIsOpen();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting query timeout");
        this.assertIsOpen();
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Setting query timeout to %d seconds".formatted(seconds));
        this.assertIsOpen();
        if (seconds < 0) {
            throw new Neo4jException(Neo4jException.GQLError.$22N02.withTemplatedMessage("query timeout", seconds));
        }
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting warnings");
        this.assertIsOpen();
        return this.warnings.get();
    }

    @Override
    public void clearWarnings() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Clearing warnings");
        this.assertIsOpen();
        this.warnings.clear();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 2);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Executing `%s` with auto generated keys set to %d".formatted(sql, autoGeneratedKeys));
        return this.execute0(sql, Map.of(), autoGeneratedKeys);
    }

    protected final boolean execute0(String sql, Map<String, Object> parameters, int autoGeneratedKeys) throws SQLException {
        this.assertIsOpen();
        StatementImpl.assertAutoGeneratedKeys(autoGeneratedKeys);
        this.closeResultSet();
        return this.recordEvent(sql, StatementListener.ExecutionStartedEvent.ExecutionMode.PLAIN, context -> {
            this.updateCount = -1;
            this.multipleResultsApi = true;
            String processedSQL = this.processSQL(sql);
            Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.SQL_PROCESSED, context)));
            Neo4jTransaction transaction = this.transactionSupplier.getTransaction(this.transactionMetadata);
            Events.notify(this.listeners, listener -> listener.on(new Neo4jEvent(Neo4jEvent.Type.TRANSACTION_ACQUIRED, context)));
            Neo4jTransaction.RunAndPullResponses responses = this.runAndPull(transaction, processedSQL, parameters, context);
            this.updateCount = responses.pullResponse().resultSummary().map(summary -> summary.counters().totalCount()).filter(count -> count > 0).orElse(-1);
            boolean containsUpdates = this.updateCount != -1;
            this.resultSet = this.newResultSet(transaction, responses, !containsUpdates || autoGeneratedKeys != 1 ? Kind.DEFAULT : Kind.GENERATED_KEYS);
            return !containsUpdates;
        });
    }

    static void assertAutoGeneratedKeys(int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys != 2 && autoGeneratedKeys != 1) {
            throw new Neo4jException(Neo4jException.withReason("Invalid value %d for parameter `autoGeneratedKeys`".formatted(autoGeneratedKeys)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T recordEvent(String statement, StatementListener.ExecutionStartedEvent.ExecutionMode executionType, SqlCallable<T> callable) throws SQLException {
        if (this.listeners.isEmpty()) {
            return callable.call(Map.of());
        }
        String id = this.statementId();
        long s = System.nanoTime();
        URI databaseURL = this.connection.unwrap(Neo4jConnection.class).getDatabaseURL();
        StatementListener.ExecutionStartedEvent startEvent = new StatementListener.ExecutionStartedEvent(id, databaseURL, this.getType(), executionType, statement);
        Events.notify(this.listeners, listener -> listener.onExecutionStarted(startEvent));
        Map<String, Object> context = Map.of("source", this.getType(), "id", id);
        StatementListener.ExecutionEndedEvent.State state = StatementListener.ExecutionEndedEvent.State.FAILED;
        try {
            T result = callable.call(context);
            state = StatementListener.ExecutionEndedEvent.State.SUCCESSFUL;
            T t = result;
            return t;
        }
        finally {
            long e = System.nanoTime();
            StatementListener.ExecutionEndedEvent endEvent = new StatementListener.ExecutionEndedEvent(id, databaseURL, state, Duration.ofNanos(e - s));
            Events.notify(this.listeners, listener -> listener.onExecutionEnded(endEvent));
        }
    }

    private String statementId() {
        String type = this.getType().getSimpleName();
        return type + "@" + HEX_FORMAT.formatHex(ENCODER.encode(Long.toString(ID_GENERATORS.computeIfAbsent(type, ignored -> new AtomicLong(0L)).getAndIncrement()).getBytes(StandardCharsets.UTF_8)));
    }

    private static Map<String, Object> getParameters(Map<String, Object> parameters) throws SQLException {
        Map result = Objects.requireNonNullElseGet(parameters, Map::of);
        for (Map.Entry entry : result.entrySet()) {
            Object object = entry.getValue();
            if (object instanceof Reader) {
                Reader reader = (Reader)object;
                try {
                    object = reader;
                    try {
                        int len;
                        StringBuilder buf = new StringBuilder();
                        char[] buffer = new char[4096];
                        while ((len = reader.read(buffer)) != -1) {
                            buf.append(buffer, 0, len);
                        }
                        entry.setValue(Values.value(buf.toString()));
                        continue;
                    }
                    finally {
                        if (object == null) continue;
                        ((Reader)object).close();
                        continue;
                    }
                }
                catch (IOException ex) {
                    throw new Neo4jException(Neo4jException.withInternal(ex));
                }
            }
            Object ex = entry.getValue();
            if (!(ex instanceof InputStream)) continue;
            InputStream inputStream = (InputStream)ex;
            try (BufferedInputStream in = new BufferedInputStream(inputStream);
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                in.transferTo(out);
                entry.setValue(Values.value(out.toByteArray()));
            }
            catch (IOException ex2) {
                throw new Neo4jException(Neo4jException.withCause(ex2));
            }
        }
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting result set");
        this.assertIsOpen();
        if (this.resultSet == null) {
            return null;
        }
        if (this.resultSet.kind() != Kind.DEFAULT) {
            throw new IllegalStateException("Only generated keys are available");
        }
        if (!this.resultSetAcquired.compareAndSet(false, true)) {
            throw new Neo4jException(Neo4jException.withReason("Result set has already been acquired"));
        }
        return this.multipleResultsApi && this.updateCount == -1 ? this.resultSet.value() : null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting update count");
        this.assertIsOpen();
        return this.multipleResultsApi ? this.updateCount : -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting more results state");
        this.assertIsOpen();
        if (this.multipleResultsApi) {
            this.closeResultSet();
            this.updateCount = -1;
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        LOGGER.log(Level.WARNING, () -> "Setting fetch direction to %d (ignored)".formatted(direction));
        this.assertIsOpen();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting fetch direction");
        this.assertIsOpen();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Setting fetch size to %d".formatted(rows));
        this.assertIsOpen();
        if (rows < 0) {
            throw new Neo4jException(Neo4jException.GQLError.$22N02.withTemplatedMessage("fetch size", rows));
        }
        this.fetchSize = rows > 0 ? rows : 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting fetch size");
        this.assertIsOpen();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting result set concurrency");
        this.assertIsOpen();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting result set type");
        this.assertIsOpen();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting connection");
        this.assertIsOpen();
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting generated keys");
        this.assertIsOpen();
        if (this.resultSet == null || this.resultSet.kind() != Kind.GENERATED_KEYS) {
            throw new Neo4jException(Neo4jException.withReason("Generated keys have not been returned"));
        }
        if (!this.resultSetAcquired.compareAndSet(false, true)) {
            throw new Neo4jException(Neo4jException.withReason("Result set has already been acquired"));
        }
        return this.resultSet.value();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting result set holdability");
        this.assertIsOpen();
        return 2;
    }

    @Override
    public boolean isClosed() {
        LOGGER.log(Level.FINER, () -> "Getting closed state");
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Setting poolable to %s".formatted(poolable));
        this.assertIsOpen();
        this.poolable = poolable;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting poolable state");
        this.assertIsOpen();
        return this.poolable;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Setting close on completion to %s".formatted(true));
        this.assertIsOpen();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        LOGGER.log(Level.FINER, () -> "Getting close on completion state");
        this.assertIsOpen();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Unwrapping `%s` into `%s`".formatted(this.getClass().getCanonicalName(), iface.getCanonicalName()));
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new Neo4jException(Neo4jException.withReason("This object does not implement the given interface"));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        LOGGER.log(Level.FINER, () -> "Enquoting identifier `%s` with always quoting set to %s".formatted(identifier, alwaysQuote));
        return SchemaNames.sanitize(identifier, alwaysQuote).orElseThrow(() -> new Neo4jException(Neo4jException.withReason("Cannot quote identifier " + identifier)));
    }

    protected void assertIsOpen() throws SQLException {
        if (this.closed) {
            throw new Neo4jException(Neo4jException.withReason("The statement set is closed"));
        }
    }

    private void closeResultSet() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.value().close();
            this.resultSet = null;
            this.resultSetAcquired.set(false);
        }
    }

    protected final String processSQL(String sql) throws SQLException {
        try {
            String processedSQL = (String)this.sqlProcessor.apply(sql);
            if (SQL_LOGGER.isLoggable(Level.FINE) && !processedSQL.equals(sql)) {
                SQL_LOGGER.log(Level.FINE, "Processed ''{0}'' into ''{1}''", new Object[]{sql, processedSQL});
            }
            return processedSQL;
        }
        catch (IllegalArgumentException | IllegalStateException | UnsupportedOperationException ex) {
            throw new Neo4jException(Neo4jException.withCause(Optional.ofNullable(ex.getCause()).orElse(ex)));
        }
    }

    @Override
    public Neo4jStatement withMetadata(Map<String, Object> metadata) {
        LOGGER.log(Level.FINER, () -> "Adding new transaction metadata");
        if (metadata != null) {
            this.transactionMetadata.putAll(metadata);
        }
        return this;
    }

    @Override
    public void addListener(StatementListener statementListener) {
        this.listeners.add(Objects.requireNonNull(statementListener));
    }

    Class<? extends Statement> getType() {
        if (this instanceof CallableStatement) {
            return CallableStatement.class;
        }
        if (this instanceof PreparedStatement) {
            return PreparedStatement.class;
        }
        return Statement.class;
    }

    @FunctionalInterface
    static interface SqlCallable<V> {
        public V call(Map<String, Object> var1) throws SQLException;
    }

    protected record ResultSetHolder(ResultSetImpl value, Kind kind) {
    }

    protected static enum Kind {
        DEFAULT,
        GENERATED_KEYS;

    }
}

