/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.net.URI;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.jdbc.Neo4jConnection;
import org.neo4j.jdbc.Neo4jStatement;
import org.neo4j.jdbc.events.ConnectionListener;
import org.neo4j.jdbc.events.Neo4jEvent;
import org.neo4j.jdbc.events.ResultSetListener;
import org.neo4j.jdbc.events.StatementListener;
import org.neo4j.jdbc.tracing.Neo4jSpan;
import org.neo4j.jdbc.tracing.Neo4jTracer;

final class Tracing
implements ConnectionListener,
StatementListener,
ResultSetListener {
    private final Neo4jTracer tracer;
    private final Map<String, Neo4jSpan> executionSpans = new ConcurrentHashMap<String, Neo4jSpan>();
    private final Map<String, Neo4jSpan> resultSetIterationSpans = new ConcurrentHashMap<String, Neo4jSpan>();
    private final Map<String, String> defaultTags;

    Tracing(Neo4jTracer tracer, Neo4jConnection connection) {
        this.tracer = tracer;
        URI uri = URI.create(connection.getDatabaseURL().getSchemeSpecificPart());
        if (uri.getHost() == null) {
            uri = URI.create(uri.getSchemeSpecificPart());
        }
        this.defaultTags = Map.of("server.address", uri.getHost(), "server.port", Integer.toString(uri.getPort()), "db.system.name", "neo4j", "db.namespace", connection.getDatabaseName());
    }

    boolean usingSameTracer(Neo4jTracer tracer) {
        return this.tracer == tracer;
    }

    @Override
    public void onStatementCreated(ConnectionListener.StatementCreatedEvent event) {
        try {
            event.statement().unwrap(Neo4jStatement.class).addListener(this);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void onExecutionStarted(StatementListener.ExecutionStartedEvent event) {
        String method = switch (event.executionMode()) {
            default -> throw new IncompatibleClassChangeError();
            case StatementListener.ExecutionStartedEvent.ExecutionMode.UPDATE -> "executeUpdate";
            case StatementListener.ExecutionStartedEvent.ExecutionMode.PLAIN -> "execute";
            case StatementListener.ExecutionStartedEvent.ExecutionMode.QUERY -> "executeQuery";
        };
        String type = event.statementType().getSimpleName();
        HashMap<String, String> tags = new HashMap<String, String>(this.defaultTags);
        tags.putAll(Map.of("db.operation.name", String.format("%s#%s".formatted(type, method), new Object[0]), "db.query.text", event.statement()));
        this.executionSpans.put(event.id(), this.tracer.start("neo4j.jdbc %s".formatted(method), tags));
    }

    @Override
    public void onExecutionEnded(StatementListener.ExecutionEndedEvent event) {
        Neo4jSpan span = this.executionSpans.remove(event.id());
        if (span != null) {
            span.end();
        }
    }

    @Override
    public void onIterationStarted(ResultSetListener.IterationStartedEvent event) {
        HashMap<String, String> tags = new HashMap<String, String>(this.defaultTags);
        tags.put("db.operation.name", "ResultSet#next");
        this.resultSetIterationSpans.put(event.id(), this.tracer.start("neo4j.jdbc iterate result", tags));
    }

    @Override
    public void onIterationDone(ResultSetListener.IterationDoneEvent event) {
        Neo4jSpan span = this.resultSetIterationSpans.remove(event.id());
        if (span != null) {
            span.end();
        }
    }

    @Override
    public void on(Neo4jEvent event) {
        Neo4jSpan span;
        Class source = (Class)event.payload().get("source");
        String id = (String)event.payload().get("id");
        if (id == null) {
            return;
        }
        if (Statement.class.isAssignableFrom(source)) {
            span = this.executionSpans.get(id);
        } else if (ResultSet.class.isAssignableFrom(source)) {
            span = this.resultSetIterationSpans.get(id);
        } else {
            return;
        }
        span.annotate(event.type().toString());
    }

    Map<String, String> defaultTags() {
        return this.defaultTags;
    }
}

