/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.authn.spi;

import java.time.Instant;
import org.neo4j.jdbc.authn.spi.DisabledAuthentication;
import org.neo4j.jdbc.authn.spi.TokenAuthentication;
import org.neo4j.jdbc.authn.spi.UsernamePasswordAuthentication;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Authentication {
    public static Authentication usernameAndPassword(String username, String password) {
        return Authentication.usernameAndPassword(username, password, null);
    }

    public static Authentication usernameAndPassword(String username, String password, String realm) {
        return new UsernamePasswordAuthentication(username, password, realm);
    }

    public static Authentication bearer(String token) {
        return Authentication.bearer(token, null);
    }

    public static Authentication bearer(String token, Instant expiresAt) {
        return new TokenAuthentication("bearer", token, expiresAt);
    }

    public static Authentication kerberos(String token) {
        return new TokenAuthentication("kerberos", token, null);
    }

    public static Authentication none() {
        return DisabledAuthentication.INSTANCE;
    }
}

