/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.bolt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.neo4j.jdbc.internal.bolt.LoggingProviderImpl;
import org.neo4j.jdbc.internal.bolt.SummaryCountersImpl;
import org.neo4j.jdbc.internal.bolt.ValueFactoryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.BoltAgent;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.SummaryCounters;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.values.Values;

public final class BoltAdapters {
    public static LoggingProvider newLoggingProvider() {
        return new LoggingProviderImpl();
    }

    public static ValueFactory getValueFactory() {
        return ValueFactoryImpl.INSTANCE;
    }

    public static BoltAgent newAgent(String driverVersion) {
        StringBuilder platformBuilder = new StringBuilder();
        BoltAdapters.getProperty("os.name").ifPresent(value -> BoltAdapters.append(value, platformBuilder));
        BoltAdapters.getProperty("os.version").ifPresent(value -> BoltAdapters.append(value, platformBuilder));
        BoltAdapters.getProperty("os.arch").ifPresent(value -> BoltAdapters.append(value, platformBuilder));
        Optional<String> language = BoltAdapters.getProperty("java.version").map(version -> "Java/" + version);
        StringBuilder languageDetailsBuilder = new StringBuilder();
        BoltAdapters.getProperty("java.vm.vendor").ifPresent(value -> BoltAdapters.append(value, languageDetailsBuilder));
        BoltAdapters.getProperty("java.vm.name").ifPresent(value -> BoltAdapters.append(value, languageDetailsBuilder));
        BoltAdapters.getProperty("java.vm.version").ifPresent(value -> BoltAdapters.append(value, languageDetailsBuilder));
        return new BoltAgent(String.format("neo4j-jdbc/%s", driverVersion), platformBuilder.isEmpty() ? null : platformBuilder.toString(), language.orElse(null), languageDetailsBuilder.isEmpty() ? null : languageDetailsBuilder.toString());
    }

    private static Optional<String> getProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (value != null) {
                value = value.trim();
            }
            return value != null && !value.isEmpty() ? Optional.of(value) : Optional.empty();
        }
        catch (SecurityException exception) {
            return Optional.empty();
        }
    }

    private static void append(String value, StringBuilder builder) {
        if (value != null && !value.isEmpty()) {
            String separator = builder.isEmpty() ? "" : "; ";
            builder.append(separator).append(value);
        }
    }

    public static Map<String, Value> adaptMap(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, Value> result = new HashMap<String, Value>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Value boltValue = ValueFactoryImpl.asBoltValue(Values.value(entry.getValue()));
            result.put(entry.getKey(), boltValue);
        }
        return Collections.unmodifiableMap(result);
    }

    public static SummaryCounters newSummaryCounters(Value countersValue) {
        if (countersValue == null) {
            return SummaryCountersImpl.EMPTY_STATS;
        }
        return new SummaryCountersImpl(BoltAdapters.counterValue(countersValue, "nodes-created"), BoltAdapters.counterValue(countersValue, "nodes-deleted"), BoltAdapters.counterValue(countersValue, "relationships-created"), BoltAdapters.counterValue(countersValue, "relationships-deleted"), BoltAdapters.counterValue(countersValue, "properties-set"), BoltAdapters.counterValue(countersValue, "labels-added"), BoltAdapters.counterValue(countersValue, "labels-removed"), BoltAdapters.counterValue(countersValue, "indexes-added"), BoltAdapters.counterValue(countersValue, "indexes-removed"), BoltAdapters.counterValue(countersValue, "constraints-added"), BoltAdapters.counterValue(countersValue, "constraints-removed"), BoltAdapters.counterValue(countersValue, "system-updates"));
    }

    private static int counterValue(Value countersValue, String name) {
        Value value = countersValue.getBoltValue(name);
        return value.isNull() ? 0 : (int)value.asLong();
    }

    private BoltAdapters() {
    }
}

