/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.jdbc.internal.shaded.bolt.DatabaseNameImpl;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DatabaseName {
    public Optional<String> databaseName();

    public String description();

    public static DatabaseName defaultDatabase() {
        return DatabaseNameImpl.DEFAULT_DATABASE;
    }

    public static DatabaseName systemDatabase() {
        return DatabaseNameImpl.SYSTEM_DATABASE;
    }

    public static DatabaseName database(String name) {
        if (Objects.equals(name, DatabaseNameImpl.DEFAULT_DATABASE_NAME)) {
            return DatabaseName.defaultDatabase();
        }
        if (Objects.equals(name, "system")) {
            return DatabaseName.systemDatabase();
        }
        return new DatabaseNameImpl(name, name);
    }
}

