/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.message;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.AuthToken;
import org.neo4j.jdbc.internal.shaded.bolt.NotificationConfig;
import org.neo4j.jdbc.internal.shaded.bolt.TelemetryApi;
import org.neo4j.jdbc.internal.shaded.bolt.TransactionType;
import org.neo4j.jdbc.internal.shaded.bolt.message.BeginMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.BeginMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.CommitMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.CommitMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.DiscardMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.DiscardMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.LogoffMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.LogoffMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.LogonMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.LogonMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.PullMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.PullMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.ResetMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.ResetMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.RollbackMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.RollbackMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.RouteMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.RouteMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.RunMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.RunMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.message.TelemetryMessage;
import org.neo4j.jdbc.internal.shaded.bolt.message.TelemetryMessageImpl;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;

public final class Messages {
    private static final CommitMessage COMMIT_MESSAGE = new CommitMessageImpl();
    private static final RollbackMessage ROLLBACK_MESSAGE = new RollbackMessageImpl();
    private static final ResetMessage RESET_MESSAGE = new ResetMessageImpl();
    private static final LogoffMessage LOGOFF_MESSAGE = new LogoffMessageImpl();

    public static RouteMessage route(String databaseName, String impersonatedUser, Set<String> bookmarks) {
        return new RouteMessageImpl(databaseName, impersonatedUser, bookmarks);
    }

    public static BeginMessage beginTransaction(String databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, TransactionType transactionType, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        return new BeginMessageImpl(databaseName, accessMode, impersonatedUser, bookmarks, transactionType, txTimeout, txMetadata, notificationConfig);
    }

    public static RunMessage run(String databaseName, AccessMode accessMode, String impersonatedUser, Set<String> bookmarks, String query, Map<String, Value> parameters, Duration txTimeout, Map<String, Value> txMetadata, NotificationConfig notificationConfig) {
        RunMessageImpl.Extra extra = new RunMessageImpl.Extra(databaseName, accessMode, impersonatedUser, bookmarks, txTimeout, txMetadata, notificationConfig);
        return new RunMessageImpl(query, parameters, extra);
    }

    public static RunMessage run(String query, Map<String, Value> parameters) {
        return new RunMessageImpl(query, parameters, null);
    }

    public static PullMessage pull(long qid, long request) {
        return new PullMessageImpl(qid, request);
    }

    public static DiscardMessage discard(long qid, long number) {
        return new DiscardMessageImpl(qid, number);
    }

    public static CommitMessage commit() {
        return COMMIT_MESSAGE;
    }

    public static RollbackMessage rollback() {
        return ROLLBACK_MESSAGE;
    }

    public static ResetMessage reset() {
        return RESET_MESSAGE;
    }

    public static LogoffMessage logoff() {
        return LOGOFF_MESSAGE;
    }

    public static LogonMessage logon(AuthToken authToken) {
        return new LogonMessageImpl(authToken);
    }

    public static TelemetryMessage telemetry(TelemetryApi telemetryApi) {
        return new TelemetryMessageImpl(telemetryApi);
    }

    private Messages() {
    }
}

