/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltProtocolException;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;

public class LogoffResponseHandler
implements ResponseHandler {
    private final CompletableFuture<?> future;

    public LogoffResponseHandler(CompletableFuture<?> future) {
        this.future = Objects.requireNonNull(future, "future must not be null");
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.future.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.future.completeExceptionally(error);
    }

    @Override
    public void onRecord(List<Value> fields) {
        this.future.completeExceptionally(new BoltProtocolException("Records are not supported on LOGON"));
    }
}

