/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.handlers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.spi.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;

public class RollbackTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Void> rollbackFuture;

    public RollbackTxResponseHandler(CompletableFuture<Void> rollbackFuture) {
        this.rollbackFuture = Objects.requireNonNull(rollbackFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.rollbackFuture.complete(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.rollbackFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(List<Value> fields) {
        throw new UnsupportedOperationException("Transaction rollback is not expected to receive records: " + String.valueOf(fields));
    }
}

