/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.CypherTypes;
import org.neo4j.jdbc.internal.shaded.bolt.values.Node;
import org.neo4j.jdbc.internal.shaded.bolt.values.Relationship;
import org.neo4j.jdbc.internal.shaded.bolt.values.Segment;
import org.neo4j.jdbc.internal.shaded.bolt.values.Type;
import org.neo4j.jdbc.internal.shaded.bolt.values.Value;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonGenerator;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonParseException;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonParser;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonToken;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.api.ReaderWriterProvider;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.api.ValueReader;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.api.ValueWriter;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl.JSONReader;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl.JSONWriter;

class DriverValueProvider
extends ReaderWriterProvider {
    private final ValueFactory valueFactory;

    public DriverValueProvider(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    @Override
    public ValueReader findValueReader(JSONReader readContext, Class<?> type) {
        if (Value.class.isAssignableFrom(type)) {
            return new ValueValueReader(Value.class, this.valueFactory);
        }
        return super.findValueReader(readContext, type);
    }

    @Override
    public ValueWriter findValueWriter(JSONWriter writeContext, Class<?> type) {
        if (Value.class.isAssignableFrom(type)) {
            return new ValueValueWriter();
        }
        return super.findValueWriter(writeContext, type);
    }

    static class ValueValueReader
    extends ValueReader {
        private final ValueFactory valueFactory;

        protected ValueValueReader(Class<?> valueType, ValueFactory valueFactory) {
            super(valueType);
            this.valueFactory = valueFactory;
        }

        @Override
        public Object read(JSONReader reader, JsonParser p) throws IOException {
            String name = p.nextFieldName();
            if (name.equals("$type")) {
                String typeString = p.nextTextValue();
                JsonToken nextToken = p.nextToken();
                if (nextToken.equals((Object)JsonToken.FIELD_NAME) && p.currentName().equals("_value")) {
                    p.nextToken();
                    if (typeString.equals(CypherTypes.List.name())) {
                        Value listValue = this.valueFactory.value(reader.readListOf(Value.class));
                        p.nextToken();
                        return listValue;
                    }
                    if (typeString.equals(CypherTypes.Map.name())) {
                        Map<String, Value> value1 = reader.readMapOf(Value.class);
                        p.nextToken();
                        return this.valueFactory.value(value1);
                    }
                    if (typeString.equals(CypherTypes.Boolean.name())) {
                        Value boolValue = this.valueFactory.value(p.getBooleanValue());
                        p.nextToken();
                        return boolValue;
                    }
                    if (typeString.equals(CypherTypes.Null.name())) {
                        if (p.currentToken().equals((Object)JsonToken.VALUE_NULL)) {
                            p.nextToken();
                            return this.valueFactory.value((Object)null);
                        }
                        throw new JsonParseException("Expected 'null' value");
                    }
                    if (typeString.equals(CypherTypes.Node.name())) {
                        SerializedNode node = reader.readBean(SerializedNode.class);
                        p.nextToken();
                        return this.valueFactory.value(this.valueFactory.node(node.getId(), node.get_element_id(), node.get_labels(), node.get_properties()));
                    }
                    if (typeString.equals(CypherTypes.Relationship.name())) {
                        SerializedRelationship relationship = reader.readBean(SerializedRelationship.class);
                        p.nextToken();
                        return this.valueFactory.value(this.valueFactory.relationship(relationship.getId(), relationship.get_element_id(), relationship.getStartId(), relationship.get_start_node_element_id(), relationship.getEndId(), relationship.get_end_node_element_id(), relationship.get_type(), relationship.get_properties()));
                    }
                    if (typeString.equals(CypherTypes.Path.name())) {
                        ArrayList<Segment> segments = new ArrayList<Segment>();
                        ArrayList<Node> nodes = new ArrayList<Node>();
                        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
                        Node start = null;
                        Relationship currentRelationship = null;
                        List<NodeOrRelationshipWrapper> list = reader.readListOf(NodeOrRelationshipWrapper.class);
                        for (NodeOrRelationshipWrapper element : list) {
                            Type elementType = element.type();
                            switch (elementType) {
                                case NODE: {
                                    NodeOrRelationship nodeValues = element.get_value();
                                    Node node = this.valueFactory.node(nodeValues.getId(), nodeValues.get_element_id(), nodeValues.get_labels(), nodeValues.get_properties());
                                    if (start != null) {
                                        segments.add(this.valueFactory.segment(start, currentRelationship, node));
                                    }
                                    start = node;
                                    nodes.add(node);
                                    break;
                                }
                                case RELATIONSHIP: {
                                    NodeOrRelationship relationshipValues = element.get_value();
                                    currentRelationship = this.valueFactory.relationship(relationshipValues.getId(), relationshipValues.get_element_id(), relationshipValues.getStartId(), relationshipValues.get_start_node_element_id(), relationshipValues.getEndId(), relationshipValues.get_end_node_element_id(), relationshipValues.get_type(), relationshipValues.get_properties());
                                    relationships.add(currentRelationship);
                                }
                            }
                        }
                        p.nextToken();
                        return this.valueFactory.value(this.valueFactory.path(segments, nodes, relationships));
                    }
                    BiFunction<ValueFactory, String, Value> parser = CypherTypes.valueOf(typeString).getReader();
                    if (parser != null) {
                        String stringValue = p.getValueAsString();
                        p.nextToken();
                        return parser.apply(this.valueFactory, stringValue);
                    }
                    throw new JsonParseException(String.format("Type %s is not a valid parameter type.", typeString));
                }
                throw new JsonParseException(String.format("Expecting field %s", "_value"));
            }
            throw new JsonParseException("Expected a typed value.");
        }
    }

    static class ValueValueWriter
    implements ValueWriter {
        ValueValueWriter() {
        }

        @Override
        public void writeValue(JSONWriter context, JsonGenerator g, Object value) throws IOException {
            CypherTypes cypherType = CypherTypes.typeFromValue((Value)value);
            g.writeStartObject();
            g.writeFieldName("$type");
            context.writeValue(cypherType.name());
            g.writeFieldName("_value");
            context.writeValue(this.fromValue(cypherType, (Value)value));
            g.writeEndObject();
        }

        private Object fromValue(CypherTypes cypherType, Value value) {
            Function<Value, Object> writer = cypherType.getWriter();
            if (writer == null) {
                throw new IllegalArgumentException("could not obtain writer for " + String.valueOf((Object)cypherType));
            }
            return writer.apply(value);
        }

        @Override
        public Class<?> valueType() {
            return Value.class;
        }
    }

    private static class NodeOrRelationship {
        private String _element_id;
        private String _start_node_element_id;
        private String _end_node_element_id;
        private List<String> _labels;
        private String _type;
        private Map<String, Value> _properties;

        private NodeOrRelationship() {
        }

        public String get_element_id() {
            return this._element_id;
        }

        public void set_element_id(String _element_id) {
            this._element_id = _element_id;
        }

        public String get_end_node_element_id() {
            return this._end_node_element_id;
        }

        public void set_end_node_element_id(String _end_node_element_id) {
            this._end_node_element_id = _end_node_element_id;
        }

        public Map<String, Value> get_properties() {
            return this._properties;
        }

        public void set_properties(Map<String, Value> _properties) {
            this._properties = _properties;
        }

        public String get_start_node_element_id() {
            return this._start_node_element_id;
        }

        public void set_start_node_element_id(String _start_node_element_id) {
            this._start_node_element_id = _start_node_element_id;
        }

        public String get_type() {
            return this._type;
        }

        public void set_type(String _type) {
            this._type = _type;
        }

        public List<String> get_labels() {
            return this._labels;
        }

        public void set_labels(List<String> _labels) {
            this._labels = _labels;
        }

        public Type type() {
            if (this.get_type() != null) {
                return Type.RELATIONSHIP;
            }
            return Type.NODE;
        }

        public long getId() {
            return Long.parseLong(this.get_element_id().split(":")[2]);
        }

        public long getStartId() {
            return Long.parseLong(this.get_start_node_element_id().split(":")[2]);
        }

        public long getEndId() {
            return Long.parseLong(this.get_end_node_element_id().split(":")[2]);
        }
    }

    private static class NodeOrRelationshipWrapper {
        private String $type;
        private NodeOrRelationship _value;

        private NodeOrRelationshipWrapper() {
        }

        public String get$type() {
            return this.$type;
        }

        public void set$type(String $type) {
            this.$type = $type;
        }

        public NodeOrRelationship get_value() {
            return this._value;
        }

        public void set_value(NodeOrRelationship _value) {
            this._value = _value;
        }

        public Type type() {
            return Type.valueOf(this.get$type().toUpperCase(Locale.ROOT));
        }
    }

    private static class SerializedRelationship {
        private String _element_id;
        private String _start_node_element_id;
        private String _end_node_element_id;
        private String _type;
        private Map<String, Value> _properties;

        private SerializedRelationship() {
        }

        public String get_element_id() {
            return this._element_id;
        }

        public void set_element_id(String _element_id) {
            this._element_id = _element_id;
        }

        public String get_end_node_element_id() {
            return this._end_node_element_id;
        }

        public void set_end_node_element_id(String _end_node_element_id) {
            this._end_node_element_id = _end_node_element_id;
        }

        public Map<String, Value> get_properties() {
            return this._properties;
        }

        public void set_properties(Map<String, Value> _properties) {
            this._properties = _properties;
        }

        public String get_start_node_element_id() {
            return this._start_node_element_id;
        }

        public void set_start_node_element_id(String _start_node_element_id) {
            this._start_node_element_id = _start_node_element_id;
        }

        public String get_type() {
            return this._type;
        }

        public void set_type(String _type) {
            this._type = _type;
        }

        public long getId() {
            return Long.parseLong(this.get_element_id().split(":")[2]);
        }

        public long getStartId() {
            return Long.parseLong(this.get_start_node_element_id().split(":")[2]);
        }

        public long getEndId() {
            return Long.parseLong(this.get_end_node_element_id().split(":")[2]);
        }
    }

    private static class SerializedNode {
        private String _element_id;
        private List<String> _labels;
        private Map<String, Value> _properties;

        private SerializedNode() {
        }

        public String get_element_id() {
            return this._element_id;
        }

        public void set_element_id(String _element_id) {
            this._element_id = _element_id;
        }

        public long getId() {
            return Long.parseLong(this.get_element_id().split(":")[2]);
        }

        public List<String> get_labels() {
            return this._labels;
        }

        public void set_labels(List<String> _labels) {
            this._labels = _labels;
        }

        public Map<String, Value> get_properties() {
            return this._properties;
        }

        public void set_properties(Map<String, Value> _properties) {
            this._properties = _properties;
        }
    }
}

