/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractPropertyContainer;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AliasedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Functions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.HasLabelCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.InternalRelationshipImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LabelExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Labels;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SortItem;

@API(status=API.Status.INTERNAL, since="2021.1.0")
abstract class AbstractNode
extends AbstractPropertyContainer
implements Node {
    AbstractNode() {
    }

    @Override
    @Deprecated(forRemoval=true)
    public final Condition hasLabels(LabelExpression labels) {
        return this.hasLabels(Labels.of(labels));
    }

    @Override
    public final Condition hasLabels(String ... labelsToQuery) {
        return HasLabelCondition.create(this.getSymbolicName().orElseThrow(() -> new IllegalStateException("Cannot query a node without a symbolic name.")), labelsToQuery);
    }

    @Override
    public final Condition hasLabels(Labels labels) {
        return HasLabelCondition.create(this.getSymbolicName().orElseThrow(() -> new IllegalStateException("Cannot query a node without a symbolic name.")), labels);
    }

    @Override
    public final Condition isEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isEqualTo(otherNode.getRequiredSymbolicName());
    }

    @Override
    public final Condition isNotEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isNotEqualTo(otherNode.getRequiredSymbolicName());
    }

    @Override
    public final Condition isNull() {
        return this.getRequiredSymbolicName().isNull();
    }

    @Override
    public final Condition isNotNull() {
        return this.getRequiredSymbolicName().isNotNull();
    }

    @Override
    public final SortItem descending() {
        return this.getRequiredSymbolicName().descending();
    }

    @Override
    public final SortItem ascending() {
        return this.getRequiredSymbolicName().ascending();
    }

    @Override
    public final AliasedExpression as(String alias) {
        return this.getRequiredSymbolicName().as(alias);
    }

    @Override
    public final FunctionInvocation internalId() {
        return Functions.id(this);
    }

    @Override
    public final FunctionInvocation labels() {
        return Functions.labels(this);
    }

    @Override
    public final Relationship relationshipTo(Node other, String ... types) {
        return new InternalRelationshipImpl(null, (Node)this, Relationship.Direction.LTR, null, other, types);
    }

    @Override
    public final Relationship relationshipFrom(Node other, String ... types) {
        return new InternalRelationshipImpl(null, (Node)this, Relationship.Direction.RTL, null, other, types);
    }

    @Override
    public final Relationship relationshipBetween(Node other, String ... types) {
        return new InternalRelationshipImpl(null, (Node)this, Relationship.Direction.UNI, null, other, types);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

