/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Arrays;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AliasedExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.annotations.CheckReturnValue;

@API(status=API.Status.STABLE, since="2020.0.1")
public interface ExposesCall<T> {
    @CheckReturnValue
    public T call(String ... var1);

    public static interface ExposesYield<T> {
        @CheckReturnValue
        default public T yield(String ... yieldedItems) {
            SymbolicName[] names = new SymbolicName[]{};
            if (yieldedItems != null) {
                names = (SymbolicName[])Arrays.stream(yieldedItems).map(SymbolicName::of).toArray(SymbolicName[]::new);
            }
            return this.yield(names);
        }

        @CheckReturnValue
        default public T yield(Named ... yieldedItems) {
            SymbolicName[] names = new SymbolicName[]{};
            if (yieldedItems != null) {
                names = (SymbolicName[])Arrays.stream(yieldedItems).map(Named::getRequiredSymbolicName).toArray(SymbolicName[]::new);
            }
            return this.yield(names);
        }

        @CheckReturnValue
        public T yield(SymbolicName ... var1);

        @CheckReturnValue
        public T yield(AliasedExpression ... var1);
    }

    public static interface AsFunction {
        default public Expression asFunction() {
            return this.asFunction(false);
        }

        public Expression asFunction(boolean var1);
    }

    public static interface ExposesWithArgs<T> {
        @CheckReturnValue
        public T withArgs(Expression ... var1);
    }
}

