/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ForeignAdapter;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class ForeignAdapterFactory {
    private final Map<Class<?>, Constructor<ForeignAdapter<?>>> adapterCache = new HashMap();

    ForeignAdapterFactory() {
    }

    private static IllegalArgumentException newCannotAdaptException(Class<?> k, Exception cause) {
        String msg = "Cannot adapt expressions of type " + k.getName() + " to Cypher-DSL expressions.";
        return new IllegalArgumentException(msg, cause);
    }

    private static Set<String> getInterfaces(Class<?> type) {
        if (type == null || type == Object.class) {
            return Set.of();
        }
        return Stream.concat(ForeignAdapterFactory.getInterfaces(type.getSuperclass()).stream(), Arrays.stream(type.getInterfaces()).flatMap(i -> Stream.concat(Stream.of(i.getName()), ForeignAdapterFactory.getInterfaces(i).stream()))).collect(Collectors.toSet());
    }

    <FE> ForeignAdapter<FE> getAdapterFor(FE expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Cannot adapt literal NULL expressions.");
        }
        Constructor constructor = this.adapterCache.computeIfAbsent(expression.getClass(), k -> {
            Set<String> interfaces = ForeignAdapterFactory.getInterfaces(k);
            if (!interfaces.stream().anyMatch("com.querydsl.core.types.Expression"::equals)) {
                throw ForeignAdapterFactory.newCannotAdaptException(k, null);
            }
            String adapterName = "org.neo4j.jdbc.internal.shaded.cypherdsl.QueryDSLAdapter";
            try {
                return Class.forName(adapterName).getDeclaredConstructors()[0];
            }
            catch (ClassNotFoundException ex) {
                throw ForeignAdapterFactory.newCannotAdaptException(k, ex);
            }
        });
        try {
            return (ForeignAdapter)constructor.newInstance(expression);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw ForeignAdapterFactory.newCannotAdaptException(expression.getClass(), ex);
        }
    }
}

