/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operations;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PropertyLookup;
import org.neo4j.jdbc.internal.shaded.cypherdsl.RendererBridge;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.INTERNAL, since="2021.1.0")
final class InternalPropertyImpl
implements Property {
    private final Named container;
    private final Expression containerReference;
    private final List<PropertyLookup> names;
    private final String externalReference;

    InternalPropertyImpl(Optional<Named> container, Expression containerReference, List<PropertyLookup> names, String externalReference) {
        this.container = container.orElse(null);
        this.containerReference = containerReference;
        this.names = names;
        this.externalReference = externalReference;
    }

    static Property create(Named parentContainer, String ... names) {
        SymbolicName requiredSymbolicName = InternalPropertyImpl.extractRequiredSymbolicName(parentContainer);
        return new InternalPropertyImpl(Optional.of(parentContainer), requiredSymbolicName, InternalPropertyImpl.createListOfChainedNames(names), null);
    }

    static Property create(Expression containerReference, String ... names) {
        Assertions.notNull(containerReference, "The property container is required.");
        return new InternalPropertyImpl(Optional.empty(), containerReference, InternalPropertyImpl.createListOfChainedNames(names), null);
    }

    static Property create(Named parentContainer, Expression lookup) {
        SymbolicName requiredSymbolicName = InternalPropertyImpl.extractRequiredSymbolicName(parentContainer);
        return new InternalPropertyImpl(Optional.of(parentContainer), requiredSymbolicName, Collections.singletonList(PropertyLookup.forExpression(lookup)), null);
    }

    static Property create(Expression containerReference, Expression lookup) {
        return new InternalPropertyImpl(Optional.empty(), containerReference, Collections.singletonList(PropertyLookup.forExpression(lookup)), null);
    }

    private static List<PropertyLookup> createListOfChainedNames(String ... names) {
        Assertions.notEmpty(names, "The properties name is required.");
        if (names.length == 1) {
            return Collections.singletonList(PropertyLookup.forName(names[0]));
        }
        return Arrays.stream(names).map(PropertyLookup::forName).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    private static SymbolicName extractRequiredSymbolicName(Named parentContainer) {
        try {
            return parentContainer.getRequiredSymbolicName();
        }
        catch (IllegalStateException ex) {
            throw new IllegalArgumentException("A property derived from a node or a relationship needs a parent with a symbolic name.");
        }
    }

    @Override
    public List<PropertyLookup> getNames() {
        return this.names;
    }

    @Override
    public Named getContainer() {
        return this.container;
    }

    @Override
    public Expression getContainerReference() {
        return this.containerReference;
    }

    @Override
    public String getName() {
        return this.externalReference != null ? this.externalReference : this.names.stream().map(PropertyLookup::getPropertyKeyName).map(SymbolicName::getValue).collect(Collectors.joining("."));
    }

    @Override
    public Property referencedAs(String newReference) {
        return new InternalPropertyImpl(Optional.ofNullable(this.container), this.containerReference, this.names, newReference);
    }

    @Override
    public Operation to(Expression expression) {
        return Operations.set(this, expression);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.containerReference.accept(visitor);
        this.names.forEach(name -> name.accept(visitor));
        visitor.leave(this);
    }

    @Override
    public Expression asExpression() {
        return this;
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

