/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.LiteralBase;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MergeAction;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Pattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.UpdatingClause;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="1.0")
public final class Merge
extends AbstractClause
implements UpdatingClause {
    private final Pattern pattern;
    private final List<Visitable> onCreateOrMatchEvents;

    Merge(Pattern pattern, List<MergeAction> mergeActions) {
        this.pattern = pattern;
        this.onCreateOrMatchEvents = new ArrayList<Visitable>();
        this.onCreateOrMatchEvents.add(LiteralBase.BLANK);
        this.onCreateOrMatchEvents.addAll(mergeActions);
    }

    @API(status=API.Status.INTERNAL)
    public boolean hasEvents() {
        return !this.onCreateOrMatchEvents.isEmpty();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.pattern.accept(visitor);
        this.onCreateOrMatchEvents.forEach(s -> s.accept(visitor));
        visitor.leave(this);
    }
}

