/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.AbstractNode;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Labels;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.NodeLabel;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Properties;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

@API(status=API.Status.STABLE, since="2021.1.0")
public abstract class NodeBase<SELF extends Node>
extends AbstractNode
implements Node {
    final List<NodeLabel> staticLabels;
    final Labels dynamicLabels;
    final Properties properties;
    final Where innerPredicate;
    private volatile SymbolicName symbolicName;

    protected NodeBase(String primaryLabel, String ... additionalLabels) {
        this((SymbolicName)null, primaryLabel, (MapExpression)null, additionalLabels);
    }

    protected NodeBase(SymbolicName symbolicName, List<NodeLabel> staticLabels, Properties properties) {
        this(symbolicName, new ArrayList<NodeLabel>(staticLabels), null, properties, null);
    }

    NodeBase() {
        this(null, Collections.emptyList(), null);
    }

    NodeBase(SymbolicName symbolicName, String primaryLabel, MapExpression properties, String ... additionalLabels) {
        this(symbolicName, NodeBase.assertLabels(primaryLabel, additionalLabels), Properties.create(properties));
    }

    NodeBase(SymbolicName symbolicName, List<NodeLabel> staticLabels, Labels dynamicLabels, Properties properties, Where innerPredicate) {
        this.symbolicName = symbolicName;
        this.staticLabels = staticLabels;
        this.dynamicLabels = dynamicLabels;
        this.properties = properties;
        this.innerPredicate = innerPredicate;
    }

    private static List<NodeLabel> assertLabels(String primaryLabel, String[] additionalLabels) {
        Assertions.hasText(primaryLabel, "A primary label is required.");
        if (additionalLabels != null) {
            for (String additionalLabel : additionalLabels) {
                Assertions.hasText(additionalLabel, "An empty label is not allowed.");
            }
        }
        ArrayList<NodeLabel> labels = new ArrayList<NodeLabel>();
        labels.add(new NodeLabel(primaryLabel));
        if (additionalLabels != null) {
            labels.addAll(Arrays.stream(additionalLabels).map(NodeLabel::new).toList());
        }
        return labels;
    }

    public final SELF named(String newSymbolicName) {
        Assertions.hasText(newSymbolicName, "Symbolic name is required.");
        return this.named(SymbolicName.of(newSymbolicName));
    }

    public abstract SELF named(SymbolicName var1);

    @Override
    public final SELF withProperties(Object ... keysAndValues) {
        MapExpression newProperties = null;
        if (keysAndValues != null && keysAndValues.length != 0) {
            newProperties = MapExpression.create(false, keysAndValues);
        }
        return (SELF)this.withProperties(newProperties);
    }

    @Override
    public final SELF withProperties(Map<String, Object> newProperties) {
        return (SELF)this.withProperties(MapExpression.create(newProperties));
    }

    @Override
    public abstract SELF withProperties(MapExpression var1);

    protected final Properties getProperties() {
        return this.properties;
    }

    @Override
    public final List<NodeLabel> getLabels() {
        return this.staticLabels != null ? List.copyOf(this.staticLabels) : List.of();
    }

    @Override
    public final Optional<SymbolicName> getSymbolicName() {
        return Optional.ofNullable(this.symbolicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SymbolicName getRequiredSymbolicName() {
        SymbolicName requiredSymbolicName = this.symbolicName;
        if (requiredSymbolicName == null) {
            NodeBase nodeBase = this;
            synchronized (nodeBase) {
                requiredSymbolicName = this.symbolicName;
                if (requiredSymbolicName == null) {
                    requiredSymbolicName = this.symbolicName = SymbolicName.unresolved();
                }
            }
        }
        return requiredSymbolicName;
    }

    @Override
    public final void accept(Visitor visitor) {
        visitor.enter(this);
        this.getSymbolicName().ifPresent(s -> s.accept(visitor));
        if (this.staticLabels != null) {
            this.staticLabels.forEach(label -> label.accept(visitor));
        }
        Visitable.visitIfNotNull(this.dynamicLabels, visitor);
        Visitable.visitIfNotNull(this.properties, visitor);
        Visitable.visitIfNotNull(this.innerPredicate, visitor);
        visitor.leave(this);
    }
}

