/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.Set;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.FunctionInvocation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Labels;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapProjection;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operator;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Parameter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.utils.Assertions;

final class Operations {
    private static final Set<Class<? extends Expression>> VALID_MUTATORS = Set.of(MapExpression.class, Parameter.class, MapProjection.class, SymbolicName.class, FunctionInvocation.class);

    private Operations() {
    }

    static Operation minus(Expression e) {
        return Operation.create(Operator.UNARY_MINUS, e);
    }

    static Expression plus(Expression e) {
        return Operation.create(Operator.UNARY_PLUS, e);
    }

    static Operation concat(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.CONCAT, op2);
    }

    static Operation add(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.ADDITION, op2);
    }

    static Operation subtract(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.SUBTRACTION, op2);
    }

    static Operation multiply(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.MULTIPLICATION, op2);
    }

    static Operation divide(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.DIVISION, op2);
    }

    static Operation remainder(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.MODULO_DIVISION, op2);
    }

    static Operation pow(Expression op1, Expression op2) {
        return Operation.create(op1, Operator.EXPONENTIATION, op2);
    }

    static Operation set(Expression target, Expression value) {
        return Operation.create(target, Operator.SET, value);
    }

    static Operation mutate(Expression target, MapExpression value) {
        return Operation.create(target, Operator.MUTATE, value);
    }

    static Operation mutate(Expression target, Expression value) {
        Assertions.notNull(value, "New properties value must not be null");
        Assertions.isTrue(Property.class.isAssignableFrom(value.getClass()) || VALID_MUTATORS.contains(value.getClass()), "A property container can only be mutated by a map, or a parameter or property pointing to a map.");
        return Operation.create(target, Operator.MUTATE, value);
    }

    static Operation set(Node target, String ... label) {
        return Operation.create(target, Operator.SET_LABEL, label);
    }

    static Operation set(Node target, Labels labels) {
        return Operation.create(target, Operator.SET_LABEL, labels);
    }

    static Operation remove(Node target, String ... label) {
        return Operation.create(target, Operator.REMOVE_LABEL, label);
    }

    static Expression remove(Node node, Labels labels) {
        return Operation.create(node, Operator.REMOVE_LABEL, labels);
    }
}

