/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Visitor;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.build.annotations.RegisterForReflection;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Conditions;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExpressionCondition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ForeignAdapter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Node;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Relationship;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SymbolicName;
import org.neo4j.jdbc.internal.shaded.cypherdsl.querydsl.CypherContext;
import org.neo4j.jdbc.internal.shaded.cypherdsl.querydsl.ToCypherFormatStringVisitor;

@API(status=API.Status.INTERNAL, since="2021.1.0")
@RegisterForReflection(allDeclaredConstructors=true)
final class QueryDSLAdapter
implements ForeignAdapter<com.querydsl.core.types.Expression<?>> {
    private final com.querydsl.core.types.Expression<?> expression;

    QueryDSLAdapter(com.querydsl.core.types.Expression<?> expression) {
        this.expression = expression;
    }

    @Override
    public Condition asCondition() {
        BooleanBuilder booleanBuilder;
        if (!(this.expression instanceof Predicate)) {
            throw new IllegalArgumentException("Only Query-DSL predicates can be turned into Cypher-DSL's predicates.");
        }
        com.querydsl.core.types.Expression<?> expression = this.expression;
        if (expression instanceof BooleanBuilder && !(booleanBuilder = (BooleanBuilder)expression).hasValue()) {
            return Conditions.noCondition();
        }
        CypherContext context = new CypherContext();
        String formatString = (String)this.expression.accept((Visitor)ToCypherFormatStringVisitor.INSTANCE, (Object)context);
        return new ExpressionCondition(Cypher.raw(formatString, context.getExpressions()));
    }

    @Override
    public Expression asExpression() {
        CypherContext context = new CypherContext();
        String formatString = (String)this.expression.accept((Visitor)ToCypherFormatStringVisitor.INSTANCE, (Object)context);
        return Cypher.raw(formatString, context.getExpressions());
    }

    @Override
    public Node asNode() {
        com.querydsl.core.types.Expression<?> expression = this.expression;
        if (!(expression instanceof Path)) {
            throw new IllegalArgumentException("Only Query-DSL paths can be turned into nodes.");
        }
        Path entityPath = (Path)expression;
        return Cypher.node(entityPath.getRoot().getType().getSimpleName(), new String[0]).named(entityPath.getMetadata().getName());
    }

    @Override
    public Relationship asRelationship() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public SymbolicName asName() {
        com.querydsl.core.types.Expression<?> expression = this.expression;
        if (!(expression instanceof Path)) {
            throw new IllegalArgumentException("Only Query-DSL paths can be turned into names.");
        }
        Path entityPath = (Path)expression;
        return Cypher.name(entityPath.getMetadata().getName());
    }
}

