/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="2023.2.0")
public final class TreeNode<E> {
    private final TreeNode<E> parent;
    private final int level;
    private final List<TreeNode<E>> children;
    private final E value;

    private TreeNode(TreeNode<E> parent, int level, E value) {
        this.parent = parent;
        this.level = level;
        this.value = value;
        this.children = new ArrayList<TreeNode<E>>();
    }

    public static TreeNode<Visitable> from(Statement statement) {
        TreeBuildingVisitor visitor = new TreeBuildingVisitor();
        statement.accept(visitor);
        return visitor.root;
    }

    static <E> TreeNode<E> root(E value) {
        return new TreeNode<E>(null, 0, value);
    }

    TreeNode<E> append(E childValue) {
        TreeNode<E> newChild = new TreeNode<E>(this, this.level + 1, childValue);
        this.children.add(newChild);
        return newChild;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getLevel() {
        return this.level;
    }

    public TreeNode<E> getParent() {
        return this.parent;
    }

    public Collection<TreeNode<E>> getChildren() {
        return List.copyOf(this.children);
    }

    public E getValue() {
        return this.value;
    }

    public Iterator<TreeNode<E>> breadthFirst() {
        return new BreadthFirstIterator(this);
    }

    public Iterator<TreeNode<E>> preOrder() {
        return new PreOrderIterator(this);
    }

    public void printTo(Consumer<CharSequence> target, Function<TreeNode<E>, String> toString) {
        this.printTo0(target, toString, this, "", true);
    }

    private void printTo0(Consumer<CharSequence> target, Function<TreeNode<E>, String> toString, TreeNode<E> node, String prefix, boolean isTail) {
        String connector;
        String localValue = toString.apply(node);
        String string = connector = isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ";
        if (this == node) {
            connector = "";
        }
        target.accept(prefix + connector + localValue + "\n");
        String newPrefix = prefix + (isTail ? " ".repeat(connector.length()) : "\u2502   ");
        for (int i = 0; i < node.children.size(); ++i) {
            TreeNode<E> child = node.children.get(i);
            this.printTo0(target, toString, child, newPrefix, i + 1 == node.getChildren().size());
        }
    }

    private static final class TreeBuildingVisitor
    implements Visitor {
        final Deque<TreeNode<Visitable>> nodes = new ArrayDeque<TreeNode<Visitable>>();
        TreeNode<Visitable> root;

        private TreeBuildingVisitor() {
        }

        @Override
        public void enter(Visitable segment) {
            TreeNode<Visitable> currentParent = this.nodes.peek();
            currentParent = currentParent == null ? TreeNode.root(segment) : currentParent.append(segment);
            this.nodes.push(currentParent);
        }

        @Override
        public void leave(Visitable segment) {
            this.root = this.nodes.pop();
        }
    }

    private static final class BreadthFirstIterator<E>
    implements Iterator<TreeNode<E>> {
        private final Queue<TreeNode<E>> queue = new ArrayDeque<TreeNode<E>>();

        BreadthFirstIterator(TreeNode<E> root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public TreeNode<E> next() {
            if (this.queue.isEmpty()) {
                throw new NoSuchElementException();
            }
            TreeNode<E> n = this.queue.remove();
            this.queue.addAll(n.children);
            return n;
        }
    }

    private static final class PreOrderIterator<E>
    implements Iterator<TreeNode<E>> {
        private final Deque<Iterator<TreeNode<E>>> stack = new ArrayDeque<Iterator<TreeNode<E>>>();

        PreOrderIterator(TreeNode<E> root) {
            this.stack.push(List.of(root).iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty() && this.stack.peek().hasNext();
        }

        @Override
        public TreeNode<E> next() {
            if (this.stack.isEmpty()) {
                throw new NoSuchElementException();
            }
            Iterator<TreeNode<E>> nodesUpNext = this.stack.peek();
            TreeNode<E> currentNode = nodesUpNext.next();
            if (!nodesUpNext.hasNext()) {
                this.stack.pop();
            }
            if (!currentNode.children.isEmpty()) {
                this.stack.push(currentNode.children.iterator());
            }
            return currentNode;
        }
    }
}

