/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl.querydsl;

import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.Template;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import java.util.Arrays;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.querydsl.CypherContext;

@API(status=API.Status.INTERNAL, since="2021.1.0")
public final class ToCypherFormatStringVisitor
implements Visitor<String, CypherContext> {
    public static final ToCypherFormatStringVisitor INSTANCE = new ToCypherFormatStringVisitor();

    private ToCypherFormatStringVisitor() {
    }

    public String visit(FactoryExpression<?> e, CypherContext context) {
        StringBuilder builder = new StringBuilder();
        builder.append("new ").append(e.getType().getSimpleName()).append("(");
        boolean first = true;
        for (Expression arg : e.getArgs()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append((String)arg.accept((Visitor)this, (Object)context));
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    public String visit(Operation<?> o, CypherContext context) {
        Template template = context.getTemplate(o.getOperator());
        if (template != null) {
            int precedence = context.getPrecedence(o.getOperator());
            StringBuilder builder = new StringBuilder();
            for (Template.Element element : template.getElements()) {
                Object rv = element.convert(o.getArgs());
                if (rv instanceof Expression) {
                    if (precedence > -1 && rv instanceof Operation && precedence < context.getPrecedence(((Operation)rv).getOperator())) {
                        builder.append("(").append((String)((Expression)rv).accept((Visitor)this, (Object)context)).append(")");
                        continue;
                    }
                    builder.append((String)((Expression)rv).accept((Visitor)this, (Object)context));
                    continue;
                }
                builder.append(rv.toString());
            }
            return builder.toString();
        }
        throw new IllegalArgumentException("unknown operation with operator " + o.getOperator().name() + " and args " + String.valueOf(o.getArgs()));
    }

    public String visit(ParamExpression<?> param, CypherContext context) {
        context.add(Cypher.parameter(param.getName()));
        return "$E";
    }

    public String visit(Path<?> p, CypherContext context) {
        Path parent = p.getMetadata().getParent();
        Object elem = p.getMetadata().getElement();
        if (parent != null) {
            Template pattern = context.getTemplate((Operator)p.getMetadata().getPathType());
            if (pattern != null) {
                List<Object> args = Arrays.asList(parent, elem);
                StringBuilder builder = new StringBuilder();
                for (Template.Element element : pattern.getElements()) {
                    Object rv = element.convert(args);
                    if (rv instanceof Expression) {
                        builder.append((String)((Expression)rv).accept((Visitor)this, (Object)context));
                        continue;
                    }
                    builder.append(rv.toString());
                }
                return builder.toString();
            }
            throw new IllegalArgumentException("No pattern for " + String.valueOf(p.getMetadata().getPathType()));
        }
        return elem.toString();
    }

    public String visit(SubQueryExpression<?> expr, CypherContext context) {
        return expr.getMetadata().toString();
    }

    public String visit(TemplateExpression<?> expr, CypherContext context) {
        StringBuilder builder = new StringBuilder();
        for (Template.Element element : expr.getTemplate().getElements()) {
            Object rv = element.convert(expr.getArgs());
            if (rv instanceof Expression) {
                builder.append((String)((Expression)rv).accept((Visitor)this, (Object)context));
                continue;
            }
            builder.append(rv.toString());
        }
        return builder.toString();
    }

    public String visit(Constant<?> expr, CypherContext context) {
        Object constantValue = expr.getConstant();
        if (constantValue == null) {
            context.add(Cypher.literalOf(null));
        } else if (constantValue instanceof Boolean) {
            context.add(Cypher.literalOf(constantValue));
        } else {
            context.add(context.getOrCreateParameterFor(constantValue));
        }
        return "$E";
    }
}

