/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl;

import java.lang.reflect.Constructor;

public class BeanConstructors {
    protected final Class<?> _valueType;
    protected Constructor<?> _noArgsCtor;
    protected Constructor<?> _recordCtor;
    protected Constructor<?> _intCtor;
    protected Constructor<?> _longCtor;
    protected Constructor<?> _stringCtor;

    public BeanConstructors(Class<?> clazz) {
        this._valueType = clazz;
    }

    public BeanConstructors addNoArgsConstructor(Constructor<?> constructor) {
        this._noArgsCtor = constructor;
        return this;
    }

    public BeanConstructors addRecordConstructor(Constructor<?> constructor) {
        this._recordCtor = constructor;
        return this;
    }

    public BeanConstructors addIntConstructor(Constructor<?> constructor) {
        this._intCtor = constructor;
        return this;
    }

    public BeanConstructors addLongConstructor(Constructor<?> constructor) {
        this._longCtor = constructor;
        return this;
    }

    public BeanConstructors addStringConstructor(Constructor<?> constructor) {
        this._stringCtor = constructor;
        return this;
    }

    public void forceAccess() {
        if (this._noArgsCtor != null) {
            this._noArgsCtor.setAccessible(true);
        }
        if (this._recordCtor != null) {
            this._recordCtor.setAccessible(true);
        }
        if (this._intCtor != null) {
            this._intCtor.setAccessible(true);
        }
        if (this._longCtor != null) {
            this._longCtor.setAccessible(true);
        }
        if (this._stringCtor != null) {
            this._stringCtor.setAccessible(true);
        }
    }

    protected Object create() throws Exception {
        if (this._noArgsCtor == null) {
            throw new IllegalStateException("Class " + this._valueType.getName() + " does not have default constructor to use");
        }
        return this._noArgsCtor.newInstance(null);
    }

    protected Object createRecord(Object[] objectArray) throws Exception {
        if (this._recordCtor == null) {
            throw new IllegalStateException("Class " + this._valueType.getName() + " does not have record constructor to use");
        }
        return this._recordCtor.newInstance(objectArray);
    }

    protected Object create(String string) throws Exception {
        if (this._stringCtor == null) {
            throw new IllegalStateException("Class " + this._valueType.getName() + " does not have single-String constructor to use");
        }
        return this._stringCtor.newInstance(string);
    }

    protected Object create(long l) throws Exception {
        if (this._longCtor != null) {
            return this._longCtor.newInstance(l);
        }
        if (this._intCtor != null) {
            return this._intCtor.newInstance((int)l);
        }
        throw new IllegalStateException("Class " + this._valueType.getName() + " does not have single-long or single-int constructor to use");
    }
}

