/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonParser;
import org.neo4j.jdbc.internal.shaded.jackson.core.JsonToken;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSON;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.JSONObjectException;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.api.ValueReader;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl.BeanConstructors;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl.BeanPropertyReader;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl.JSONReader;
import org.neo4j.jdbc.internal.shaded.jackson.jr.ob.impl.RecordsHelpers;

public class BeanReader
extends ValueReader {
    protected final Map<String, BeanPropertyReader> _propsByName;
    protected final Map<String, String> _aliasMapping;
    protected final Set<String> _ignorableNames;
    protected final BeanConstructors _constructors;
    protected final boolean _isRecordType;

    public BeanReader(Class<?> clazz, Map<String, BeanPropertyReader> map, BeanConstructors beanConstructors, Set<String> set, Map<String, String> map2) {
        super(clazz);
        this._propsByName = map;
        this._constructors = beanConstructors;
        if (set == null) {
            set = Collections.emptySet();
        }
        this._ignorableNames = set;
        if (map2 == null) {
            map2 = Collections.emptyMap();
        }
        this._aliasMapping = map2;
        this._isRecordType = RecordsHelpers.isRecordType(clazz);
    }

    @Deprecated
    public BeanReader(Class<?> clazz, Map<String, BeanPropertyReader> map, Constructor<?> constructor, Constructor<?> constructor2, Constructor<?> constructor3, Set<String> set, Map<String, String> map2) {
        this(clazz, map, new BeanConstructors(clazz).addNoArgsConstructor(constructor).addStringConstructor(constructor2).addLongConstructor(constructor3), set, map2);
    }

    public Map<String, BeanPropertyReader> propertiesByName() {
        return this._propsByName;
    }

    public BeanPropertyReader findProperty(String string) {
        BeanPropertyReader beanPropertyReader = this._propsByName.get(string);
        if (beanPropertyReader == null) {
            return this._findAlias(string);
        }
        return beanPropertyReader;
    }

    private final BeanPropertyReader _findAlias(String string) {
        String string2 = this._aliasMapping.get(string);
        return string2 == null ? null : this._propsByName.get(string2);
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this._constructors.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this._constructors.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    if (this._isRecordType) {
                        return this.readRecord(jSONReader, jsonParser);
                    }
                    Object object = this._constructors.create();
                    Object[] objectArray = jSONReader._setterBuffer;
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanPropertyReader beanPropertyReader = this.findProperty(string);
                        if (beanPropertyReader == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        objectArray[0] = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
                        beanPropertyReader.setValueFor(object, objectArray);
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, "Failed to create an instance of " + this._valueType.getName() + " due to (" + exception.getClass().getName() + "): " + exception.getMessage(), exception);
        }
        throw JSONObjectException.from(jsonParser, "Can not create a " + this._valueType.getName() + " instance out of " + BeanReader._tokenDesc(jsonParser));
    }

    private Object readRecord(JSONReader jSONReader, JsonParser jsonParser) throws Exception {
        String string;
        Object[] objectArray = new Object[this._propsByName.size()];
        while ((string = jsonParser.nextFieldName()) != null) {
            Object object;
            BeanPropertyReader beanPropertyReader = this.findProperty(string);
            if (beanPropertyReader == null) {
                this.handleUnknown(jSONReader, jsonParser, string);
                continue;
            }
            objectArray[beanPropertyReader.getIndex()] = object = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
        }
        return this._constructors.createRecord(objectArray);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        try {
            switch (jsonToken) {
                case VALUE_NULL: {
                    return null;
                }
                case VALUE_STRING: {
                    return this._constructors.create(jsonParser.getText());
                }
                case VALUE_NUMBER_INT: {
                    return this._constructors.create(jsonParser.getLongValue());
                }
                case START_OBJECT: {
                    String string;
                    if (this._isRecordType) {
                        return this.readRecord(jSONReader, jsonParser);
                    }
                    Object object = this._constructors.create();
                    Object[] objectArray = jSONReader._setterBuffer;
                    while ((string = jsonParser.nextFieldName()) != null) {
                        BeanPropertyReader beanPropertyReader = this.findProperty(string);
                        if (beanPropertyReader == null) {
                            this.handleUnknown(jSONReader, jsonParser, string);
                            continue;
                        }
                        objectArray[0] = beanPropertyReader.getReader().readNext(jSONReader, jsonParser);
                        beanPropertyReader.setValueFor(object, objectArray);
                    }
                    if (!jsonParser.hasToken(JsonToken.END_OBJECT)) {
                        throw this._reportProblem(jsonParser);
                    }
                    return object;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JSONObjectException.from(jsonParser, exception, "Failed to create an instance of %s due to (%s): %s", this._valueType.getName(), exception.getClass().getName(), exception.getMessage());
        }
        throw JSONObjectException.from(jsonParser, "Can not create a %s instance out of %s", this._valueType.getName(), BeanReader._tokenDesc(jsonParser));
    }

    protected void handleUnknown(JSONReader jSONReader, JsonParser jsonParser, String string) throws IOException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_BEAN_PROPERTY.isEnabled(jSONReader._features) && !this._ignorableNames.contains(string)) {
            StringBuilder stringBuilder = new StringBuilder(60);
            Iterator<String> iterator = new TreeSet<String>(this._propsByName.keySet()).iterator();
            if (iterator.hasNext()) {
                stringBuilder.append('\"').append(iterator.next()).append('\"');
                while (iterator.hasNext()) {
                    stringBuilder.append(", \"").append(iterator.next()).append('\"');
                }
            }
            throw JSONObjectException.from(jsonParser, "Unrecognized JSON property \"%s\" for Bean type `%s` (known properties: [%s])", string, this._valueType.getName(), stringBuilder.toString());
        }
        jsonParser.nextToken();
        jsonParser.skipChildren();
    }

    protected IOException _reportProblem(JsonParser jsonParser) {
        return JSONObjectException.from(jsonParser, "Unexpected token " + (Object)((Object)jsonParser.currentToken()) + "; should get FIELD_NAME or END_OBJECT");
    }
}

