/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.CharacterSet;
import org.neo4j.jdbc.internal.shaded.jooq.Collation;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Generator;
import org.neo4j.jdbc.internal.shaded.jooq.Nullability;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class ArrayDataType<T>
extends DefaultDataType<T[]> {
    final DataType<T> elementType;

    public ArrayDataType(DataType<T> elementType) {
        super(null, elementType.getArrayType(), elementType.getTypeName() + " array", elementType.getCastTypeName() + " array");
        this.elementType = elementType;
    }

    ArrayDataType(AbstractDataType<T[]> t, DataType<T> elementType, Integer precision, Integer scale, Integer length, Nullability nullability, boolean readonly, Generator<?, ?, T[]> generatedAlwaysAs, QOM.GenerationOption generationOption, QOM.GenerationLocation generationLocation, Collation collation, CharacterSet characterSet, boolean identity, Field<T[]> defaultValue) {
        super(t, precision, scale, length, nullability, readonly, generatedAlwaysAs, generationOption, generationLocation, collation, characterSet, identity, defaultValue);
        this.elementType = elementType;
    }

    @Override
    DefaultDataType<T[]> construct(Integer newPrecision, Integer newScale, Integer newLength, Nullability newNullability, boolean newReadonly, Generator<?, ?, T[]> newGeneratedAlwaysAs, QOM.GenerationOption newGenerationOption, QOM.GenerationLocation newGenerationLocation, Collation newCollation, CharacterSet newCharacterSet, boolean newIdentity, Field<T[]> newDefaultValue) {
        return new ArrayDataType<T>(this, (AbstractDataType)this.elementType, newPrecision, newScale, newLength, newNullability, newReadonly, newGeneratedAlwaysAs, newGenerationOption, newGenerationLocation, newCollation, newCharacterSet, newIdentity, newDefaultValue);
    }

    @Override
    public final String getTypeName() {
        return this.getTypeName(Tools.CONFIG.get());
    }

    @Override
    public final String getTypeName(Configuration configuration) {
        String typeName = this.elementType.getTypeName(configuration);
        return ArrayDataType.getArrayType(configuration, typeName);
    }

    @Override
    public final String getCastTypeName() {
        return this.getCastTypeName(Tools.CONFIG.get());
    }

    @Override
    public final String getCastTypeName(Configuration configuration) {
        String castTypeName = this.elementType.getCastTypeName(configuration);
        return ArrayDataType.getArrayType(configuration, castTypeName);
    }

    @Override
    public final Class<?> getArrayComponentType() {
        return this.elementType.getType();
    }

    @Override
    public final DataType<?> getArrayComponentDataType() {
        return this.elementType;
    }

    @Override
    public final Class<?> getArrayBaseType() {
        return this.getArrayBaseDataType().getType();
    }

    @Override
    public final DataType<?> getArrayBaseDataType() {
        DataType<?> t;
        DataType<T[]> result = this;
        while ((t = result.getArrayComponentDataType()) != null) {
            result = t;
        }
        return result;
    }

    private static String getArrayType(Configuration configuration, String dataType) {
        switch (configuration.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                return dataType + "[]";
            }
            case H2: {
                return dataType + " array";
            }
        }
        return dataType + " array";
    }
}

