/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Asterisk;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Keyword;
import org.neo4j.jdbc.internal.shaded.jooq.Name;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractQueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Lazy;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class AsteriskImpl
extends AbstractQueryPart
implements Asterisk {
    static final Lazy<AsteriskImpl> INSTANCE = Lazy.of(() -> new AsteriskImpl(new QueryPartList()));
    static final Set<SQLDialect> SUPPORT_NATIVE_EXCEPT = SQLDialect.supportedBy(SQLDialect.H2);
    static final Set<SQLDialect> NO_SUPPORT_UNQUALIFIED_COMBINED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL);
    final QueryPartList<Field<?>> fields;

    private AsteriskImpl(QueryPartList<Field<?>> fields) {
        this.fields = fields;
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.sql('*');
        if (!this.fields.isEmpty()) {
            ctx.sql(' ').visit(Keywords.K_EXCEPT).sql(" (").visit(this.fields).sql(')');
        }
    }

    static final Keyword keyword(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                return Keywords.K_EXCLUDE;
            }
        }
        return Keywords.K_EXCEPT;
    }

    @Override
    public final Asterisk except(String ... fieldNames) {
        return this.except(Tools.fieldsByName(fieldNames));
    }

    @Override
    public final Asterisk except(Name ... fieldNames) {
        return this.except(Tools.fieldsByName(fieldNames));
    }

    @Override
    public final Asterisk except(Field<?> ... f) {
        return this.except(Arrays.asList(f));
    }

    @Override
    public final Asterisk except(Collection<? extends Field<?>> f) {
        QueryPartList list = new QueryPartList();
        list.addAll((Collection<Field<?>>)this.fields);
        list.addAll((Collection<Field<?>>)f);
        return new AsteriskImpl(list);
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $except() {
        return QOM.unmodifiable(this.fields);
    }
}

