/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import org.neo4j.jdbc.internal.shaded.jooq.Binding;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetResultSetContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetSQLInputContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingGetStatementContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingRegisterContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSQLContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSetSQLOutputContext;
import org.neo4j.jdbc.internal.shaded.jooq.BindingSetStatementContext;
import org.neo4j.jdbc.internal.shaded.jooq.Converter;
import org.neo4j.jdbc.internal.shaded.jooq.Converters;
import org.neo4j.jdbc.internal.shaded.jooq.ResourceManagingScope;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.conf.ParamType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.ClobBinding;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultExecuteContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.R2DBC;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc.JDBCUtils;

public class BlobBinding
implements Binding<byte[], byte[]> {
    static final Set<SQLDialect> NO_SUPPORT_LOBS = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);

    @Override
    public final Converter<byte[], byte[]> converter() {
        return Converters.identity(byte[].class);
    }

    @Override
    public final void sql(BindingSQLContext<byte[]> ctx) throws SQLException {
        if (ctx.render().paramType() == ParamType.INLINED) {
            ctx.render().visit(DSL.inline((Object)ctx.convert(this.converter()).value(), SQLDataType.BLOB));
        } else {
            ctx.render().sql(ctx.variable());
        }
    }

    @Override
    public final void register(BindingRegisterContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.statement().registerOutParameter(ctx.index(), 2004);
        } else {
            ctx.statement().registerOutParameter(ctx.index(), -2);
        }
    }

    @Override
    public final void set(BindingSetStatementContext<byte[]> ctx) throws SQLException {
        if (ctx.statement() instanceof R2DBC.R2DBCPreparedStatement) {
            ctx.statement().setBytes(ctx.index(), ctx.value());
        } else if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = BlobBinding.newBlob(ctx, ctx.value(), ctx.statement().getConnection());
            if (blob == null && ClobBinding.NO_SUPPORT_NULL_LOBS.contains((Object)ctx.dialect())) {
                ctx.statement().setNull(ctx.index(), 2004);
            } else {
                ctx.statement().setBlob(ctx.index(), blob);
            }
        } else {
            ctx.statement().setBytes(ctx.index(), ctx.value());
        }
    }

    @Override
    public final void set(BindingSetSQLOutputContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            ctx.output().writeBlob(BlobBinding.newBlob(ctx, ctx.value(), null));
        } else {
            ctx.output().writeBytes(ctx.value());
        }
    }

    @Override
    public final void get(BindingGetResultSetContext<byte[]> ctx) throws SQLException {
        if (ctx.resultSet() instanceof R2DBC.R2DBCResultSet) {
            ctx.value(ctx.resultSet().getBytes(ctx.index()));
        } else if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.resultSet().getBlob(ctx.index());
            try {
                ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        } else {
            ctx.value(ctx.resultSet().getBytes(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetStatementContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.statement().getBlob(ctx.index());
            try {
                ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        } else {
            ctx.value(ctx.statement().getBytes(ctx.index()));
        }
    }

    @Override
    public final void get(BindingGetSQLInputContext<byte[]> ctx) throws SQLException {
        if (!NO_SUPPORT_LOBS.contains((Object)ctx.dialect())) {
            Blob blob = ctx.input().readBlob();
            try {
                ctx.value(blob == null ? null : blob.getBytes(1L, Tools.asInt(blob.length())));
            }
            finally {
                JDBCUtils.safeFree(blob);
            }
        } else {
            ctx.value(ctx.input().readBytes());
        }
    }

    static final Blob newBlob(ResourceManagingScope scope, byte[] bytes, Connection connection) throws SQLException {
        if (bytes == null) {
            return null;
        }
        switch (scope.dialect()) {
            default: 
        }
        Blob blob = (connection != null ? connection : DefaultExecuteContext.localConnection()).createBlob();
        scope.autoFree(blob);
        blob.setBytes(1L, bytes);
        return blob;
    }
}

