/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Arrays;
import java.util.function.BiFunction;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.CreateViewAsStep;
import org.neo4j.jdbc.internal.shaded.jooq.CreateViewFinalStep;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.QueryPart;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.ResultQuery;
import org.neo4j.jdbc.internal.shaded.jooq.SQL;
import org.neo4j.jdbc.internal.shaded.jooq.Select;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractDDLQuery;
import org.neo4j.jdbc.internal.shaded.jooq.impl.CreateViewImpl;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class CreateViewImplWithFieldNameFunctionImpl<R extends Record>
extends AbstractDDLQuery
implements CreateViewAsStep<R>,
CreateViewFinalStep,
QOM.UTransient {
    private final boolean ifNotExists;
    private final boolean orReplace;
    private final Table<?> view;
    private final BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction;
    private Field<?>[] fields;
    private ResultQuery<?> select;
    private CreateViewImpl<?> delegate;

    CreateViewImplWithFieldNameFunctionImpl(Configuration configuration, Table<?> view, BiFunction<? super Field<?>, ? super Integer, ? extends Field<?>> fieldNameFunction, boolean ifNotExists, boolean orReplace) {
        super(configuration);
        this.view = view;
        this.fields = null;
        this.fieldNameFunction = fieldNameFunction;
        this.ifNotExists = ifNotExists;
        this.orReplace = orReplace;
    }

    @Override
    public final CreateViewFinalStep as(ResultQuery<? extends R> as) {
        this.select = as;
        if (this.fieldNameFunction != null) {
            if (as instanceof Select) {
                Select s = (Select)as;
                this.fields = Tools.map(s.getSelect(), this.fieldNameFunction::apply, Field[]::new);
            } else {
                this.fields = Tools.map(as.fields(), this.fieldNameFunction::apply, Field[]::new);
            }
        }
        return this.delegate();
    }

    @Override
    public final CreateViewFinalStep as(SQL sql) {
        this.select = DSL.resultQuery(sql);
        if (this.fieldNameFunction != null) {
            this.fields = Tools.map(this.delegate().parsed().getSelect(), this.fieldNameFunction::apply, Field[]::new);
        }
        return this.delegate();
    }

    private final CreateViewImpl<?> delegate() {
        if (this.delegate == null) {
            this.delegate = new CreateViewImpl(this.configuration(), this.view, Arrays.asList(this.fields), this.orReplace, this.ifNotExists, false, this.select);
        }
        return this.delegate;
    }

    @Override
    public final CreateViewFinalStep as(String sql) {
        return this.as(DSL.sql(sql));
    }

    @Override
    public final CreateViewFinalStep as(String sql, Object ... bindings) {
        return this.as(DSL.sql(sql, bindings));
    }

    @Override
    public final CreateViewFinalStep as(String sql, QueryPart ... parts) {
        return this.as(DSL.sql(sql, parts));
    }

    @Override
    public final void accept(Context<?> ctx) {
        ctx.visit(this.delegate());
    }
}

