/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.CloseableDSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.ConnectionProvider;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.conf.Settings;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultCloseableConnectionProvider;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultConnectionFactory;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DefaultDSLContext;
import org.neo4j.jdbc.internal.shaded.jooq.impl.R2DBC;
import org.neo4j.jdbc.internal.shaded.jooq.tools.jdbc.JDBCUtils;
import org.neo4j.jdbc.internal.shaded.r2dbc.spi.ConnectionFactory;

public class DefaultCloseableDSLContext
extends DefaultDSLContext
implements CloseableDSLContext {
    public DefaultCloseableDSLContext(ConnectionProvider connectionProvider, SQLDialect dialect, Settings settings) {
        super(connectionProvider, dialect, settings);
    }

    public DefaultCloseableDSLContext(ConnectionProvider connectionProvider, SQLDialect dialect) {
        super(connectionProvider, dialect);
    }

    public DefaultCloseableDSLContext(ConnectionFactory connectionFactory, SQLDialect dialect, Settings settings) {
        super(connectionFactory, dialect, settings);
    }

    public DefaultCloseableDSLContext(ConnectionFactory connectionFactory, SQLDialect dialect) {
        super(connectionFactory, dialect);
    }

    @Override
    public void close() {
        ConnectionProvider cp = this.configuration().connectionProvider();
        ConnectionFactory cf = this.configuration().connectionFactory();
        if (cp instanceof DefaultCloseableConnectionProvider) {
            DefaultCloseableConnectionProvider dcp = (DefaultCloseableConnectionProvider)cp;
            JDBCUtils.safeClose(dcp.connection);
            dcp.connection = null;
        }
        if (cf instanceof DefaultConnectionFactory) {
            DefaultConnectionFactory dcf = (DefaultConnectionFactory)cf;
            if (dcf.finalize) {
                R2DBC.blockWrappingExceptions(dcf.connection.close());
                dcf.connection = null;
            }
        }
    }
}

