/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.ExecuteType;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.RecordContext;
import org.neo4j.jdbc.internal.shaded.jooq.RecordType;
import org.neo4j.jdbc.internal.shaded.jooq.Result;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractScope;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.FieldsImpl;

class DefaultRecordContext
extends AbstractScope
implements RecordContext {
    private final ExecuteType type;
    private final Record record;
    Exception exception;

    DefaultRecordContext(Configuration configuration, ExecuteType type, Record record) {
        super(configuration);
        this.type = type;
        this.record = record;
    }

    @Override
    public final ExecuteType type() {
        return this.type;
    }

    @Override
    public final Record record() {
        return this.record;
    }

    @Override
    public final Record[] batchRecords() {
        return new Record[]{this.record};
    }

    @Override
    public final RecordType<?> recordType() {
        return new FieldsImpl(this.record.fields());
    }

    @Override
    public final Exception exception() {
        return this.exception;
    }

    public String toString() {
        Result<Record> result = DSL.using(this.configuration).newResult(this.record.fields());
        result.add(this.record);
        return result.toString();
    }
}

